import { jsx } from 'react/jsx-runtime';
import React__default from 'react';
import styled from 'styled-components';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';

const BoxGrow = styled(Box) `
  flex-grow: 1;
  overflow-y: auto;
`;
const NavSections = ({ children, spacing = 4, horizontal = false, ...props }) => {
    return (jsx(BoxGrow, { paddingLeft: 3, paddingRight: 2, paddingTop: 3, paddingBottom: 8, children: jsx(Flex, { as: "ul", gap: spacing, direction: horizontal ? 'row' : 'column', alignItems: horizontal ? 'center' : 'stretch', ...props, children: React__default.Children.map(children, (child, index) => {
                // eslint-disable-next-line react/no-array-index-key
                return jsx("li", { children: child }, index);
            }) }) }));
};

export { NavSections };
