import { jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { Box } from '../Box/Box.mjs';

const AnchorBox = styled(Box) `
  text-decoration: none;

  &:focus {
    left: ${({ theme }) => theme.spaces[3]};
    top: ${({ theme }) => theme.spaces[3]};
  }
`;
const SkipToContent = ({ children }) => {
    return (jsx(AnchorBox, { as: "a", href: "#main-content", background: "primary600", color: "neutral0", left: "-100%", padding: 3, position: "absolute", top: "-100%", hasRadius: true, zIndex: 9999, children: children }));
};

export { SkipToContent };
