'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const React = require('react');
const constants = require('./constants.js');

const notifyLog = (message) => {
    const logEl = document.querySelector(`#${constants.LiveRegionIds.Log}`);
    if (logEl) {
        logEl.innerText = message;
    }
};
const notifyStatus = (message) => {
    const statusEl = document.querySelector(`#${constants.LiveRegionIds.Status}`);
    if (statusEl) {
        statusEl.innerText = message;
    }
};
const notifyAlert = (message) => {
    const alertEl = document.querySelector(`#${constants.LiveRegionIds.Alert}`);
    if (alertEl) {
        alertEl.innerText = message;
    }
};
const useNotifyAT = () => {
    React.useEffect(() => {
        return () => {
            notifyLog('');
            notifyAlert('');
            notifyStatus('');
        };
    }, []);
    return { notifyLog, notifyAlert, notifyStatus };
};

exports.useNotifyAT = useNotifyAT;
