import { jsxs, jsx } from 'react/jsx-runtime';
import * as React from 'react';
import { ExternalLink } from '@strapi/icons';
import { NavLink } from 'react-router-dom';
import styled from 'styled-components';
import { buttonFocusStyle } from '../themes/utils.mjs';
import { Typography } from '../Typography/Typography.mjs';
import { Box } from '../Box/Box.mjs';

const LinkWrapper = styled.a `
  display: inline-flex;
  align-items: center;
  text-decoration: none;
  pointer-events: ${({ disabled }) => (disabled ? 'none' : undefined)};
  color: ${({ disabled, theme }) => (disabled ? theme.colors.neutral600 : theme.colors.primary600)};

  svg path {
    transition: fill 150ms ease-out;
    fill: currentColor;
  }

  svg {
    font-size: ${10 / 16}rem;
  }

  ${Typography} {
    transition: color 150ms ease-out;
    color: currentColor;
  }

  &:hover {
    color: ${({ theme }) => theme.colors.primary500};
  }

  &:active {
    color: ${({ theme }) => theme.colors.primary700};
  }

  ${buttonFocusStyle};
`;
const IconWrapper = styled(Box) `
  display: flex;
`;
const Link = React.forwardRef(({ children, href, to, disabled = false, startIcon, endIcon, ...restProps }, ref) => {
    const target = href ? '_blank' : undefined;
    const rel = href ? 'noreferrer noopener' : undefined;
    return (jsxs(LinkWrapper, { as: to && !disabled ? NavLink : 'a', target: target, rel: rel, to: disabled ? undefined : to, href: disabled ? '#' : href, disabled: disabled, ref: ref, ...restProps, children: [startIcon && (jsx(IconWrapper, { as: "span", "aria-hidden": true, paddingRight: 2, children: startIcon })), jsx(Typography, { children: children }), endIcon && !href && (jsx(IconWrapper, { as: "span", "aria-hidden": true, paddingLeft: 2, children: endIcon })), href && (jsx(IconWrapper, { as: "span", "aria-hidden": true, paddingLeft: 2, children: jsx(ExternalLink, {}) }))] }));
});

export { Link };
