import { jsxs, jsx } from 'react/jsx-runtime';
import styled from 'styled-components';
import { Box } from '../Box/Box.mjs';

const GridContainer = styled(Box) `
  display: grid;
  grid-template-columns: ${({ hasSideNav }) => (hasSideNav ? `auto 1fr` : '1fr')};
`;
const OverflowingItem = styled(Box) `
  overflow-x: hidden;
`;
const Layout = ({ sideNav, children }) => {
    return (jsxs(GridContainer, { hasSideNav: Boolean(sideNav), children: [sideNav, jsx(OverflowingItem, { paddingBottom: 10, children: children })] }));
};

export { Layout };
