'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const Box = require('../Box/Box.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const GridContainer = styled__default.default(Box.Box) `
  display: grid;
  grid-template-columns: ${({ hasSideNav }) => (hasSideNav ? `auto 1fr` : '1fr')};
`;
const OverflowingItem = styled__default.default(Box.Box) `
  overflow-x: hidden;
`;
const Layout = ({ sideNav, children }) => {
    return (jsxRuntime.jsxs(GridContainer, { hasSideNav: Boolean(sideNav), children: [sideNav, jsxRuntime.jsx(OverflowingItem, { paddingBottom: 10, children: children })] }));
};

exports.Layout = Layout;
