'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const useElementOnScreen = require('../hooks/useElementOnScreen.js');
const useResizeObserver = require('../hooks/useResizeObserver.js');
const Box = require('../Box/Box.js');
const Flex = require('../Flex/Flex.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const React__default = /*#__PURE__*/_interopDefault(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const HeaderLayout = (props) => {
    const baseHeaderLayoutRef = React.useRef(null);
    const [headerSize, setHeaderSize] = React.useState(null);
    const [containerRef, isVisible] = useElementOnScreen.useElementOnScreen({
        root: null,
        rootMargin: '0px',
        threshold: 0,
    });
    useResizeObserver.useResizeObserver(containerRef, () => {
        if (containerRef.current) {
            setHeaderSize(containerRef.current.getBoundingClientRect());
        }
    });
    React.useEffect(() => {
        if (baseHeaderLayoutRef.current) {
            setHeaderSize(baseHeaderLayoutRef.current.getBoundingClientRect());
        }
    }, [baseHeaderLayoutRef]);
    return (jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [jsxRuntime.jsx("div", { style: { height: headerSize?.height }, ref: containerRef, children: isVisible && jsxRuntime.jsx(BaseHeaderLayout, { ref: baseHeaderLayoutRef, ...props }) }), !isVisible && jsxRuntime.jsx(BaseHeaderLayout, { ...props, sticky: true, width: headerSize?.width })] }));
};
HeaderLayout.displayName = 'HeaderLayout';
const StickyBox = styled__default.default(Box.Box) `
  width: ${({ width }) => (width ? `${width / 16}rem` : undefined)};
  z-index: ${({ theme }) => theme.zIndices[1]};
`;
const BaseHeaderLayout = React__default.default.forwardRef(({ navigationAction, primaryAction, secondaryAction, subtitle, title, sticky, width, ...props }, ref) => {
    const isSubtitleString = typeof subtitle === 'string';
    if (sticky) {
        return (jsxRuntime.jsx(StickyBox, { paddingLeft: 6, paddingRight: 6, paddingTop: 3, paddingBottom: 3, position: "fixed", top: 0, right: 0, background: "neutral0", shadow: "tableShadow", width: width, "data-strapi-header-sticky": true, children: jsxRuntime.jsxs(Flex.Flex, { justifyContent: "space-between", children: [jsxRuntime.jsxs(Flex.Flex, { children: [navigationAction && jsxRuntime.jsx(Box.Box, { paddingRight: 3, children: navigationAction }), jsxRuntime.jsxs(Box.Box, { children: [jsxRuntime.jsx(Typography.Typography, { variant: "beta", as: "h1", ...props, children: title }), isSubtitleString ? (jsxRuntime.jsx(Typography.Typography, { variant: "pi", textColor: "neutral600", children: subtitle })) : (subtitle)] }), secondaryAction ? jsxRuntime.jsx(Box.Box, { paddingLeft: 4, children: secondaryAction }) : null] }), jsxRuntime.jsx(Flex.Flex, { children: primaryAction ? jsxRuntime.jsx(Box.Box, { paddingLeft: 2, children: primaryAction }) : undefined })] }) }));
    }
    return (jsxRuntime.jsxs(Box.Box, { ref: ref, paddingLeft: 10, paddingRight: 10, paddingBottom: 8, paddingTop: navigationAction ? 6 : 8, background: "neutral100", "data-strapi-header": true, children: [navigationAction ? jsxRuntime.jsx(Box.Box, { paddingBottom: 2, children: navigationAction }) : null, jsxRuntime.jsxs(Flex.Flex, { justifyContent: "space-between", children: [jsxRuntime.jsxs(Flex.Flex, { minWidth: 0, children: [jsxRuntime.jsx(Typography.Typography, { as: "h1", variant: "alpha", ...props, children: title }), secondaryAction ? jsxRuntime.jsx(Box.Box, { paddingLeft: 4, children: secondaryAction }) : null] }), primaryAction] }), isSubtitleString ? (jsxRuntime.jsx(Typography.Typography, { variant: "epsilon", textColor: "neutral600", as: "p", children: subtitle })) : (subtitle)] }));
});

exports.BaseHeaderLayout = BaseHeaderLayout;
exports.HeaderLayout = HeaderLayout;
