'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const state = require('@codemirror/state');
const view = require('@codemirror/view');

// Effects can be attached to transactions to communicate with the extension
const addMarks = state.StateEffect.define();
const filterMarks = state.StateEffect.define();
const lineHighlightMark = view.Decoration.mark({
    attributes: { style: 'background-color: yellow; color: black' },
});
const markField = state.StateField.define({
    // Start with an empty set of decorations
    create() {
        return view.Decoration.none;
    },
    // This is called whenever the editor updates it computes the new set
    update(value, transaction) {
        // Move the decorations to account for document changes
        value = value.map(transaction.changes);
        transaction.effects.forEach((effect) => {
            if (effect.is(addMarks)) {
                value = value.update({
                    add: effect.value,
                    sort: true,
                });
            }
            else if (effect.is(filterMarks)) {
                value = value.update({ filter: effect.value });
            }
        });
        return value;
    },
    // Indicate that this field provides a set of decorations
    provide: (f) => view.EditorView.decorations.from(f),
});

exports.addMarks = addMarks;
exports.filterMarks = filterMarks;
exports.lineHighlightMark = lineHighlightMark;
exports.markField = markField;
