import { jsxs, jsx } from 'react/jsx-runtime';
import * as React from 'react';
import styled from 'styled-components';
import { VisuallyHidden } from '../VisuallyHidden/VisuallyHidden.mjs';
import { Tooltip } from '../Tooltip/Tooltip.mjs';
import { BaseButton } from '../BaseButton/BaseButton.mjs';
import { Flex } from '../Flex/Flex.mjs';

// TODO: we should align the default state in v2 with the Button
// component
const VARIANT_DEFAULT = 'tertiary';
const VARIANT_SECONDARY = 'secondary';
const SIZES = ['S', 'M', 'L'];
const VARIANTS = [VARIANT_DEFAULT, VARIANT_SECONDARY];
const IconButton = React.forwardRef(({ label, background, borderWidth, noBorder = false, children, icon, disabled = false, onClick, size = SIZES[0], 'aria-label': ariaLabel, variant = VARIANTS[0], ...restProps }, ref) => {
    const handleClick = (e) => {
        if (!disabled && onClick) {
            onClick(e);
        }
    };
    const component = (jsxs(IconButtonWrapper, { "aria-disabled": disabled, background: disabled ? 'neutral150' : background, borderWidth: noBorder ? 0 : borderWidth, justifyContent: "center", ...restProps, ref: ref, size: size, onClick: handleClick, variant: variant, children: [jsx(VisuallyHidden, { as: "span", children: label ?? ariaLabel }), React.cloneElement((icon || children), {
                'aria-hidden': true,
                focusable: false, // See: https://allyjs.io/tutorials/focusing-in-svg.html#making-svg-elements-focusable
            })] }));
    return label ? jsx(Tooltip, { label: label, children: component }) : component;
});
const IconButtonWrapper = styled(BaseButton) `
  background-color: ${({ theme, variant }) => {
    if (variant === VARIANT_SECONDARY) {
        return theme.colors.primary100;
    }
    return undefined;
}};
  border-color: ${({ theme, variant }) => {
    if (variant === VARIANT_SECONDARY) {
        return theme.colors.primary200;
    }
    return theme.colors.neutral200;
}};
  height: ${({ theme, size }) => theme.sizes.button[size]};
  width: ${({ theme, size }) => theme.sizes.button[size]};

  svg {
    g,
    path {
      fill: ${({ theme, variant }) => {
    if (variant === VARIANT_SECONDARY) {
        return theme.colors.primary500;
    }
    return theme.colors.neutral500;
}};
    }
  }

  :hover,
  :focus {
    svg {
      g,
      path {
        fill: ${({ theme, variant }) => {
    if (variant === VARIANT_SECONDARY) {
        return theme.colors.primary600;
    }
    return theme.colors.neutral600;
}};
      }
    }
  }

  &[aria-disabled='true'] {
    svg {
      path {
        fill: ${({ theme }) => theme.colors.neutral600};
      }
    }
  }
`;
const IconButtonGroup = styled(Flex) `
  & span:first-child button {
    border-left: 1px solid ${({ theme }) => theme.colors.neutral200};
    border-radius: ${({ theme }) => `${theme.borderRadius} 0 0 ${theme.borderRadius}`};
  }

  & span:last-child button {
    border-radius: ${({ theme }) => `0 ${theme.borderRadius} ${theme.borderRadius} 0`};
  }

  & ${IconButtonWrapper} {
    border-radius: 0;
    border-left: none;

    svg {
      path {
        fill: ${({ theme }) => theme.colors.neutral700};
      }
    }

    &:hover {
      background-color: ${({ theme }) => theme.colors.neutral100};

      svg {
        path {
          fill: ${({ theme }) => theme.colors.neutral800};
        }
      }
    }

    &:active {
      background-color: ${({ theme }) => theme.colors.neutral150};
      svg {
        path {
          fill: ${({ theme }) => theme.colors.neutral900};
        }
      }
    }

    &[aria-disabled='true'] {
      svg {
        path {
          fill: ${({ theme }) => theme.colors.neutral600};
        }
      }
    }
  }
`;

export { IconButton, IconButtonGroup };
