'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const handleResponsiveValues = require('../helpers/handleResponsiveValues.js');
const Box = require('../Box/Box.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const GridWrapper = styled__default.default(Box.Box) `
  display: grid;
  grid-template-columns: repeat(${({ gridCols }) => gridCols}, 1fr);
  ${({ theme, gap }) => handleResponsiveValues('gap', gap, theme)}
`;
const Grid = (props) => {
    const { gap = '0', gridCols = 12, ...rest } = props;
    return jsxRuntime.jsx(GridWrapper, { gap: gap, gridCols: gridCols, ...rest });
};

exports.Grid = Grid;
