'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const styled = require('styled-components');
const handleResponsiveValues = require('../helpers/handleResponsiveValues.js');
const Box = require('../Box/Box.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

/**
 * Prevents these attributes from being spread on the DOM node
 */
const transientProps = {
    direction: true,
};
const Flex = styled__default.default(Box.Box).withConfig({
    shouldForwardProp: (prop, defPropValFN) => !transientProps[prop] && defPropValFN(prop),
}) `
  align-items: ${({ alignItems = 'center' }) => alignItems};
  display: ${({ display = 'flex', inline }) => (inline ? 'inline-flex' : display)};
  flex-direction: ${({ direction = 'row' }) => direction};
  flex-shrink: ${({ shrink }) => shrink};
  flex-wrap: ${({ wrap }) => wrap};
  ${({ gap, theme }) => handleResponsiveValues('gap', gap, theme)};
  justify-content: ${({ justifyContent }) => justifyContent};
`;

exports.Flex = Flex;
