'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const FieldContext = require('./FieldContext.js');
const utils = require('../themes/utils.js');
const Box = require('../Box/Box.js');
const Flex = require('../Flex/Flex.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

// padding-[top|bottom] must ensure, the input matches the height of getThemeSize('input')
const PADDING_Y = {
    S: 6.5,
    M: 10.5,
};
const FieldInput = React.forwardRef(({ endAction, startAction, disabled = false, onChange, size = 'M', ...props }, ref) => {
    const { id, error, hint, name, required } = FieldContext.useField();
    let ariaDescription;
    if (error) {
        ariaDescription = `${id}-error`;
    }
    else if (hint) {
        ariaDescription = `${id}-hint`;
    }
    const hasError = Boolean(error);
    const handleChange = (e) => {
        if (!disabled && onChange) {
            onChange(e);
        }
    };
    return (jsxRuntime.jsxs(InputWrapper, { justifyContent: "space-between", hasError: hasError, disabled: disabled, children: [startAction ? (jsxRuntime.jsx(Box.Box, { paddingLeft: 3, paddingRight: 2, children: startAction })) : null, jsxRuntime.jsx(Input, { id: id, name: name, ref: ref, "aria-describedby": ariaDescription, "aria-invalid": hasError, "aria-disabled": disabled, disabled: disabled, "data-disabled": disabled ? '' : undefined, hasLeftAction: Boolean(startAction), hasRightAction: Boolean(endAction), onChange: handleChange, "aria-required": required, "$size": size, ...props }), endAction ? (jsxRuntime.jsx(Box.Box, { paddingLeft: 2, paddingRight: 3, children: endAction })) : null] }));
});
const Input = styled__default.default.input `
  border: none;
  border-radius: ${({ theme }) => theme.borderRadius};
  padding-bottom: ${({ $size }) => `${PADDING_Y[$size] / 16}rem`};
  padding-left: ${({ theme, hasLeftAction }) => (hasLeftAction ? 0 : theme.spaces[4])};
  padding-right: ${({ theme, hasRightAction }) => (hasRightAction ? 0 : theme.spaces[4])};
  padding-top: ${({ $size }) => `${PADDING_Y[$size] / 16}rem`};
  cursor: ${(props) => (props['aria-disabled'] ? 'not-allowed' : undefined)};

  color: ${({ theme }) => theme.colors.neutral800};
  font-weight: 400;
  font-size: ${(props) => props.theme.fontSizes[2]};
  display: block;
  width: 100%;
  background: inherit;

  ::placeholder {
    color: ${({ theme }) => theme.colors.neutral500};
    opacity: 1;
  }

  &[aria-disabled='true'] {
    color: inherit;
  }

  //focus managed by InputWrapper
  &:focus {
    outline: none;
    box-shadow: none;
  }
`;
const InputWrapper = styled__default.default(Flex.Flex) `
  border: 1px solid ${({ theme, hasError }) => (hasError ? theme.colors.danger600 : theme.colors.neutral200)};
  border-radius: ${({ theme }) => theme.borderRadius};
  background: ${({ theme }) => theme.colors.neutral0};
  ${utils.inputFocusStyle()}

  ${({ theme, disabled }) => disabled
    ? styled.css `
          color: ${theme.colors.neutral600};
          background: ${theme.colors.neutral150};
        `
    : undefined}
`;

exports.FieldInput = FieldInput;
exports.InputWrapper = InputWrapper;
