'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const FieldContext = require('./FieldContext.js');
const Typography = require('../Typography/Typography.js');

const FieldHint = () => {
    const { id, hint, error } = FieldContext.useField();
    if (!hint || error) {
        return null;
    }
    return (jsxRuntime.jsx(Typography.Typography, { variant: "pi", as: "p", id: `${id}-hint`, textColor: "neutral600", children: hint }));
};

exports.FieldHint = FieldHint;
