import { jsxs, jsx } from 'react/jsx-runtime';
import { forwardRef, cloneElement } from 'react';
import styled from 'styled-components';
import { Flex } from '../Flex/Flex.mjs';
import { VisuallyHidden } from '../VisuallyHidden/VisuallyHidden.mjs';

const FieldActionWrapper = styled(Flex) `
  font-size: 1.6rem;
  padding: 0;
`;
const FieldAction = forwardRef(({ label, children, ...props }, ref) => (jsxs(FieldActionWrapper, { justifyContent: "unset", background: "transparent", borderStyle: "none", type: "button", ...props, as: "button", ref: ref, children: [jsx(VisuallyHidden, { as: "span", children: label }), cloneElement(children, {
            'aria-hidden': true,
            focusable: false, // See: https://allyjs.io/tutorials/focusing-in-svg.html#making-svg-elements-focusable
        })] })));

export { FieldAction };
