'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const context = require('./helpers/context.js');
const ThemeProvider = require('./ThemeProvider/ThemeProvider.js');

const DEFAULT_LOCALE = 'en-EN';
const getDefaultLocale = () => {
    if (typeof navigator === 'undefined') {
        return DEFAULT_LOCALE;
    }
    if (navigator.language) {
        return navigator.language;
    }
    return DEFAULT_LOCALE;
};
const [Provider, useDesignSystem] = context.createContext('StrapiDesignSystem', {
    locale: getDefaultLocale(),
});
const DesignSystemProvider = ({ locale = getDefaultLocale(), ...restProps }) => {
    return (jsxRuntime.jsx(Provider, { locale: locale, children: jsxRuntime.jsx(ThemeProvider.ThemeProvider, { ...restProps }) }));
};

exports.DesignSystemProvider = DesignSystemProvider;
exports.useDesignSystem = useDesignSystem;
