'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const date = require('@internationalized/date');
const styled = require('styled-components');
const DatePicker$1 = require('../DatePicker/DatePicker.js');
const DesignSystemProvider = require('../DesignSystemProvider.js');
const deprecations = require('../helpers/deprecations.js');
const useComposeRefs = require('../hooks/useComposeRefs.js');
const useControllableState = require('../hooks/useControllableState.js');
const useDateFormatter = require('../hooks/useDateFormatter.js');
const useId = require('../hooks/useId.js');
const TimePicker$1 = require('../TimePicker/TimePicker.js');
const Field = require('../Field/Field.js');
const Flex = require('../Flex/Flex.js');
const FieldLabel = require('../Field/FieldLabel.js');
const VisuallyHidden = require('../VisuallyHidden/VisuallyHidden.js');
const FieldHint = require('../Field/FieldHint.js');
const FieldError = require('../Field/FieldError.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const DateTimePicker = React__namespace.forwardRef(({ 
/**
 * @preserve
 * @deprecated This is no longer used.
 */
ariaLabel: _ariaLabel, clearLabel = 'clear', dateLabel = 'Choose date', timeLabel = 'Choose time', disabled = false, error, hint, id, label, labelAction, onChange, onClear, name, required = false, 
/**
 * @preserve
 * @deprecated This is no longer used.
 */
selectButtonTitle: _selectButtonTitle, size = 'M', step, value, initialDate, ...props }, forwardedRef) => {
    const DatePickerElement = React__namespace.useRef(null);
    const [dateValue, setDateValue] = useControllableState.useControllableState({
        defaultProp: initialDate ? convertUTCDateToCalendarDateTime(initialDate, false) : undefined,
        prop: value ? convertUTCDateToCalendarDateTime(value, false) : value ?? undefined,
        onChange(date$1) {
            if (onChange) {
                onChange(date$1?.toDate(date.getLocalTimeZone()));
            }
        },
    });
    const context = DesignSystemProvider.useDesignSystem('DateTimePicker');
    const timeFormatter = useDateFormatter.useDateFormatter(context.locale, {
        hour: '2-digit',
        minute: '2-digit',
        hour12: false,
    });
    const timeValue = dateValue ? timeFormatter.format(dateValue.toDate(date.getLocalTimeZone())) : '';
    // React.useEffect(() => {
    //   setTimeTextValue((s) => (s === timeValue ? s : timeValue));
    // }, [timeValue]);
    const handleDateChange = (date) => {
        let newDate = date ? convertUTCDateToCalendarDateTime(date) : undefined;
        /**
         * If the date hasn't changed, don't do anything.
         */
        if (newDate && dateValue && newDate.compare(dateValue) === 0) {
            return;
        }
        if (timeValue && newDate) {
            const [hours, minutes] = timeValue.split(':');
            newDate = newDate.set({ hour: parseInt(hours, 10), minute: parseInt(minutes, 10) });
        }
        setDateValue(newDate);
    };
    const handleTimeChange = (time) => {
        if (!time) {
            return;
        }
        const [hours, minutes] = time.split(':');
        const dateToSet = dateValue
            ? dateValue.set({ hour: parseInt(hours, 10), minute: parseInt(minutes, 10) })
            : convertUTCDateToCalendarDateTime(new Date()).set({
                hour: parseInt(hours, 10),
                minute: parseInt(minutes, 10),
            });
        setDateValue(dateToSet);
    };
    const handleDateClear = (e) => {
        setDateValue(undefined);
        // setTimeTextValue('');
        if (onClear) {
            onClear(e);
        }
    };
    const handleTimeClear = () => {
        const newDate = dateValue ? dateValue.set({ hour: 0, minute: 0 }) : convertUTCDateToCalendarDateTime(new Date());
        setDateValue(newDate);
        // setTimeTextValue('');
    };
    const generatedId = useId.useId(id);
    const timeId = useId.useId();
    const dateId = useId.useId();
    const composedRefs = useComposeRefs.useComposedRefs(DatePickerElement, forwardedRef);
    return (jsxRuntime.jsx(Field.Field, { name: name, as: "fieldset", id: generatedId, "aria-labelledby": generatedId, hint: hint, error: error, required: required, children: jsxRuntime.jsxs(Flex.Flex, { as: "span", direction: "column", alignItems: "stretch", gap: 1, children: [jsxRuntime.jsx(FieldLabel.FieldLabel, { onClick: () => {
                        /**
                         * We're using fieldsets and legends and because they're not directly associated with the input
                         * we want to manually focus the input because the labels for these inputs are visually hidden.
                         */
                        DatePickerElement.current.focus();
                    }, as: "legend", id: generatedId, action: labelAction, children: label }), jsxRuntime.jsxs(Flex.Flex, { flex: "1", gap: 1, children: [jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { as: "label", htmlFor: dateId, children: dateLabel }), jsxRuntime.jsx(DatePicker, { ...props, selectedDate: dateValue?.toDate('UTC'), onChange: handleDateChange, error: typeof error === 'string', required: required, size: size, onClear: onClear ? handleDateClear : undefined, clearLabel: `${clearLabel} date`, disabled: disabled, id: dateId, ref: composedRefs, "aria-describedby": `${generatedId}-hint ${generatedId}-error` }), jsxRuntime.jsx(VisuallyHidden.VisuallyHidden, { as: "label", htmlFor: timeId, children: timeLabel }), jsxRuntime.jsx(TimePicker, { size: size, error: typeof error === 'string', value: timeValue, onChange: handleTimeChange, onClear: onClear && timeValue !== undefined && timeValue !== '00:00' ? handleTimeClear : undefined, clearLabel: `${clearLabel} time`, required: required, disabled: disabled, step: step, id: timeId, "aria-describedby": `${generatedId}-hint ${generatedId}-error` })] }), jsxRuntime.jsx(FieldHint.FieldHint, {}), jsxRuntime.jsx(FieldError.FieldError, {})] }) }));
});
const warnOnce = deprecations.once(console.warn);
const convertUTCDateToCalendarDateTime = (date$1, resetTime = true) => {
    /**
     * TODO: remove this in V2, it's a deprecated API
     */
    if (typeof date$1 === 'string') {
        warnOnce("It looks like you're passing a string as representation of a Date to the DatePicker. This is deprecated, look to passing a Date instead.");
        const timestamp = Date.parse(date$1);
        if (!Number.isNaN(timestamp)) {
            date$1 = new Date(timestamp);
        }
        else {
            date$1 = new Date();
        }
    }
    const utcDateString = date$1.toISOString();
    let zonedDateTime = date.parseAbsoluteToLocal(utcDateString);
    if (resetTime) {
        zonedDateTime = zonedDateTime.set({ hour: 0, minute: 0 });
    }
    /**
     * ZonedDateTime can't have weeks added,
     * see – https://github.com/adobe/react-spectrum/issues/3667
     */
    return date.toCalendarDateTime(zonedDateTime);
};
const DatePicker = styled__default.default(DatePicker$1.DatePickerInput) `
  flex: 1 1 70%;
  min-width: 120px;
`;
const TimePicker = styled__default.default(TimePicker$1.TimePickerInput) `
  flex: 1 1 30%;
  min-width: 140px;
`;

exports.DateTimePicker = DateTimePicker;
exports.convertUTCDateToCalendarDateTime = convertUTCDateToCalendarDateTime;
