'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const styled = require('styled-components');
const Flex = require('../Flex/Flex.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const CardAssetImg = styled__default.default.img `
  // inline flows is based on typography and displays an extra white space below the image
  // switch to block is required in order to make the img stick the bottom of the container
  // addition infos: https://stackoverflow.com/questions/5804256/image-inside-div-has-extra-space-below-the-image
  margin: 0;
  padding: 0;
  max-height: 100%;
  max-width: 100%;
  object-fit: contain;
`;
const sizes = {
    S: 88,
    M: 164,
};
const CardAssetWrapper = styled__default.default.div `
  display: flex;
  justify-content: center;
  height: ${({ size }) => sizes[size] / 16}rem;
  width: 100%;
  background: repeating-conic-gradient(${({ theme }) => theme.colors.neutral100} 0% 25%, transparent 0% 50%) 50% / 20px
    20px;
  border-top-left-radius: ${({ theme }) => theme.borderRadius};
  border-top-right-radius: ${({ theme }) => theme.borderRadius};
`;
const CardAsset = ({ size = 'M', children, ...props }) => {
    return (jsxRuntime.jsx(CardAssetWrapper, { size: size, children: children ? jsxRuntime.jsx(Flex.Flex, { children: children }) : jsxRuntime.jsx(CardAssetImg, { ...props, "aria-hidden": true }) }));
};

exports.CardAsset = CardAsset;
