import { jsxs, jsx } from 'react/jsx-runtime';
import { ChevronRight } from '@strapi/icons';
import styled from 'styled-components';
import { VisuallyHidden } from '../VisuallyHidden/VisuallyHidden.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Box } from '../Box/Box.mjs';
import { Typography } from '../Typography/Typography.mjs';

const CrumbWrapper = styled(Flex) `
  svg {
    height: ${10 / 16}rem;
    width: ${10 / 16}rem;
    path {
      fill: ${({ theme }) => theme.colors.neutral500};
    }
  }
  :last-of-type ${Box} {
    display: none;
  }
  :last-of-type ${Typography} {
    color: ${({ theme }) => theme.colors.neutral800};
    font-weight: ${({ theme }) => theme.fontWeights.bold};
  }
`;
const Crumb = ({ children }) => {
    return (jsxs(CrumbWrapper, { inline: true, as: "li", children: [jsx(Typography, { variant: "pi", textColor: "neutral600", children: children }), jsx(Box, { "aria-hidden": true, paddingLeft: 3, paddingRight: 3, children: jsx(ChevronRight, {}) })] }));
};
Crumb.displayName = 'Crumb';
const Breadcrumbs = ({ children, label, ...props }) => (jsxs(Flex, { ...props, children: [jsx(VisuallyHidden, { children: label }), jsx("ol", { "aria-hidden": true, children: children })] }));
Breadcrumbs.displayName = 'Breadcrumbs';

export { Breadcrumbs, Crumb };
