import { jsxs, jsx } from 'react/jsx-runtime';
import { Cross, CheckCircle, ExclamationMarkCircle, Information } from '@strapi/icons';
import styled from 'styled-components';
import { handleIconColor, handleBackgroundColor, handleBorderColor } from './utils.mjs';
import { buttonFocusStyle } from '../themes/utils.mjs';
import { Box } from '../Box/Box.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Typography } from '../Typography/Typography.mjs';

const CloseButton = styled(Box) `
  svg {
    height: 100%;
    width: 100%;

    path {
      fill: ${({ theme }) => theme.colors.neutral700};
    }
  }

  ${buttonFocusStyle};
`;
const AlertIconWrapper = styled(Flex) `
  svg {
    height: 100%;
    width: 100%;

    path {
      fill: ${handleIconColor};
    }
  }
`;
const AlertIcon = ({ variant, ...props }) => {
    if (variant === 'success') {
        return jsx(CheckCircle, { ...props });
    }
    if (variant === 'danger' || variant === 'warning') {
        return jsx(ExclamationMarkCircle, { ...props });
    }
    return jsx(Information, { ...props });
};
const ActionBox = styled(Box) `
  & a > span {
    color: ${handleIconColor};
  }

  svg path {
    fill: ${handleIconColor};
  }
`;
const Alert = ({ title, children, variant = 'default', onClose, closeLabel, titleAs = 'p', action, ...props }) => {
    return (jsxs(Flex, { alignItems: "flex-start", background: handleBackgroundColor(variant), borderColor: handleBorderColor(variant), boxShadow: "filterShadow", gap: 3, hasRadius: true, padding: 5, paddingRight: 6, variant: variant, ...props, children: [jsx(AlertIconWrapper, { height: `${20 / 16}rem`, shrink: 0, variant: variant, width: `${20 / 16}rem`, children: jsx(AlertIcon, { "aria-hidden": true, variant: variant }) }), jsxs(Flex, { alignItems: "start", gap: action ? 2 : 1, wrap: "wrap", role: variant === 'danger' ? 'alert' : 'status', width: "100%", children: [title && (jsx(Typography, { fontWeight: "bold", textColor: "neutral800", as: titleAs, children: title })), jsx(Typography, { as: "p", textColor: "neutral800", children: children }), action && jsx(ActionBox, { variant: variant, children: action })] }), jsx(CloseButton, { as: "button", background: "transparent", borderColor: undefined, height: `${12 / 16}rem`, marginTop: 1, onClick: onClose, width: `${12 / 16}rem`, "aria-label": closeLabel, children: jsx(Cross, { "aria-hidden": true }) })] }));
};

export { Alert };
