'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const icons = require('@strapi/icons');
const styled = require('styled-components');
const Accordion = require('./Accordion.js');
const AccordionContext = require('./AccordionContext.js');
const utils = require('./utils.js');
const TextButton = require('../TextButton/TextButton.js');
const Icon = require('../Icon/Icon.js');
const Flex = require('../Flex/Flex.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

const styled__default = /*#__PURE__*/_interopDefault(styled);

const ToggleButton = styled__default.default(TextButton.TextButton) `
  text-align: left;

  // necessary to make the ellipsis prop work on the title
  > span {
    max-width: 100%;
  }

  svg {
    width: ${14 / 16}rem;
    height: ${14 / 16}rem;

    path {
      fill: ${({ theme, expanded }) => (expanded ? theme.colors.primary600 : theme.colors.neutral500)};
    }
  }
`;
const FlexWithSize = styled__default.default(Flex.Flex) `
  min-height: ${({ theme, size }) => theme.sizes.accordions[size]};
  border-radius: ${({ theme, expanded }) => expanded ? `${theme.borderRadius} ${theme.borderRadius} 0 0` : theme.borderRadius};

  &:hover {
    svg {
      path {
        fill: ${({ theme }) => theme.colors.primary600};
      }
    }
  }
`;
const AccordionToggle = ({ title, description, as = 'span', togglePosition = 'right', action, ...props }) => {
    const { onToggle, toggle, expanded, id, size, variant, disabled } = AccordionContext.useAccordion();
    // Accessibility identifiers
    const ariaControls = `accordion-content-${id}`;
    const ariaLabelId = `accordion-label-${id}`;
    const ariaDescriptionId = `accordion-desc-${id}`;
    // Style overrides
    const boxPaddingX = size === 'M' ? 6 : 4;
    const boxPaddingY = size === 'M' ? boxPaddingX : boxPaddingX - 2;
    const boxBackground = utils.getBackground({ expanded, disabled, variant });
    const titleColor = expanded ? 'primary600' : 'neutral700';
    const titleProps = {
        as,
        fontWeight: size === 'S' ? 'bold' : undefined,
        id: ariaLabelId,
        textColor: titleColor,
        ellipsis: true,
        variant: size === 'M' ? 'delta' : undefined,
    };
    const descriptionColor = expanded ? 'primary600' : 'neutral600';
    const iconColor = expanded ? 'primary200' : 'neutral200';
    const iconSize = size === 'M' ? `${32 / 16}rem` : `${24 / 16}rem`;
    const handleToggle = () => {
        if (!disabled) {
            if (toggle && !onToggle) {
                console.warn('Deprecation warning: Usage of "toggle" prop in Accordion component is deprecated. This is discouraged and will be removed in the next major release. Please use "onToggle" instead');
                toggle();
            }
            else if (onToggle) {
                onToggle();
            }
        }
    };
    const dropdownIcon = (jsxRuntime.jsx(Flex.Flex, { justifyContent: "center", borderRadius: "50%", height: iconSize, width: iconSize, transform: expanded ? `rotate(180deg)` : undefined, "data-strapi-dropdown": true, "aria-hidden": true, as: "span", background: iconColor, cursor: disabled ? 'not-allowed' : 'pointer', onClick: handleToggle, shrink: 0, children: jsxRuntime.jsx(Icon.Icon, { as: icons.CarretDown, width: size === 'M' ? `${11 / 16}rem` : `${8 / 16}rem`, color: expanded ? 'primary600' : 'neutral600' }) }));
    return (jsxRuntime.jsx(FlexWithSize, { paddingBottom: boxPaddingY, paddingLeft: boxPaddingX, paddingRight: boxPaddingX, paddingTop: boxPaddingY, background: boxBackground, expanded: expanded, size: size, justifyContent: "space-between", cursor: disabled ? 'not-allowed' : '', children: jsxRuntime.jsxs(Flex.Flex, { gap: 3, flex: 1, maxWidth: "100%", children: [togglePosition === 'left' && dropdownIcon, jsxRuntime.jsx(ToggleButton, { onClick: handleToggle, "aria-disabled": disabled, "aria-expanded": expanded, "aria-controls": ariaControls, "aria-labelledby": ariaLabelId, "data-strapi-accordion-toggle": true, expanded: expanded, type: "button", flex: 1, minWidth: 0, ...props, children: jsxRuntime.jsxs(jsxRuntime.Fragment, { children: [jsxRuntime.jsx(Accordion.AccordionTypography, { ...titleProps, children: title }), description && (jsxRuntime.jsx(Typography.Typography, { as: "p", id: ariaDescriptionId, textColor: descriptionColor, children: description }))] }) }), togglePosition === 'right' && (jsxRuntime.jsxs(Flex.Flex, { gap: 3, children: [dropdownIcon, action] })), togglePosition === 'left' && action] }) }));
};

exports.AccordionToggle = AccordionToggle;
