'use strict';

Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const jsxRuntime = require('react/jsx-runtime');
const React = require('react');
const styled = require('styled-components');
const KeyboardNavigable = require('../KeyboardNavigable/KeyboardNavigable.js');
const Box = require('../Box/Box.js');
const Flex = require('../Flex/Flex.js');
const Typography = require('../Typography/Typography.js');

const _interopDefault = e => e && e.__esModule ? e : { default: e };

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  const n = Object.create(null, { [Symbol.toStringTag]: { value: 'Module' } });
  if (e) {
    for (const k in e) {
      if (k !== 'default') {
        const d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: () => e[k]
        });
      }
    }
  }
  n.default = e;
  return Object.freeze(n);
}

const React__namespace = /*#__PURE__*/_interopNamespace(React);
const styled__default = /*#__PURE__*/_interopDefault(styled);

const AccordionFooter = styled__default.default(Box.Box) `
  border-bottom: 1px solid ${({ theme }) => theme.colors.neutral200};
  border-right: 1px solid ${({ theme }) => theme.colors.neutral200};
  border-left: 1px solid ${({ theme }) => theme.colors.neutral200};
  border-radius: 0 0 ${({ theme }) => theme.borderRadius} ${({ theme }) => theme.borderRadius};
`;
const EnhancedGroup = styled__default.default(Box.Box) `
  & > * {
    & > * {
      border-radius: unset;
    }
  }

  & > * {
    border-radius: unset;
    border-right: 1px solid ${({ theme }) => theme.colors.neutral200};
    border-left: 1px solid ${({ theme }) => theme.colors.neutral200};
    border-bottom: 1px solid ${({ theme }) => theme.colors.neutral200};
  }

  & > *:first-of-type {
    border-top: 1px solid ${({ theme }) => theme.colors.neutral200};
    border-radius: ${({ theme }) => theme.borderRadius} ${({ theme }) => theme.borderRadius} 0 0;
    & > * {
      border-radius: ${({ theme }) => theme.borderRadius} ${({ theme }) => theme.borderRadius} 0 0;
    }

    &:hover {
      border-top: 1px solid ${({ theme }) => theme.colors.primary600};
    }
  }

  & [data-strapi-expanded='true'] {
    border: 1px solid ${({ theme }) => theme.colors.primary600};
  }

  ${({ theme, footer }) => `
    &:not(${footer}) {
      & > *:last-of-type {
        border-radius: 0 0 ${theme.borderRadius} ${theme.borderRadius};
      }
    }
  `}
`;
const LabelAction = styled__default.default(Box.Box) `
  svg path {
    fill: ${({ theme }) => theme.colors.neutral500};
  }
`;
const AccordionGroup = ({ children, footer, label, labelAction, error }) => {
    const childrenArray = React__namespace.Children.toArray(children).map((child) => {
        return React__namespace.cloneElement(child, { hasErrorMessage: false });
    });
    return (jsxRuntime.jsxs(KeyboardNavigable.KeyboardNavigable, { attributeName: "data-strapi-accordion-toggle", children: [label && (jsxRuntime.jsxs(Flex.Flex, { paddingBottom: 1, children: [jsxRuntime.jsx(Typography.Typography, { variant: "pi", as: "label", textColor: "neutral800", fontWeight: "bold", children: label }), labelAction && jsxRuntime.jsx(LabelAction, { paddingLeft: 1, children: labelAction })] })), jsxRuntime.jsx(EnhancedGroup, { footer: footer, children: childrenArray }), footer && jsxRuntime.jsx(AccordionFooter, { children: footer }), error && (jsxRuntime.jsx(Box.Box, { paddingTop: 1, children: jsxRuntime.jsx(Typography.Typography, { variant: "pi", textColor: "danger600", children: error }) }))] }));
};

exports.AccordionGroup = AccordionGroup;
