import { jsx } from 'react/jsx-runtime';
import { useAccordion } from './AccordionContext.mjs';
import { Box } from '../Box/Box.mjs';

const AccordionContent = ({ children, ...props }) => {
    const { expanded, id } = useAccordion();
    if (!expanded) {
        return null;
    }
    const idContent = `accordion-content-${id}`;
    const ariaLabelId = `accordion-label-${id}`;
    const ariaDescriptionId = `accordion-desc-${id}`;
    return (jsx(Box, { role: "region", id: idContent, "aria-labelledby": ariaLabelId, "aria-describedby": ariaDescriptionId, ...props, children: children }));
};

export { AccordionContent };
