import { jsxs, jsx } from 'react/jsx-runtime';
import * as React from 'react';
import styled from 'styled-components';
import { AccordionContext } from './AccordionContext.mjs';
import { useId } from '../hooks/useId.mjs';
import { Typography } from '../Typography/Typography.mjs';
import { Flex } from '../Flex/Flex.mjs';
import { Box } from '../Box/Box.mjs';

const getBorder = ({ theme, expanded, variant, disabled, error }) => {
    if (error) {
        return `1px solid ${theme.colors.danger600} !important`;
    }
    if (disabled) {
        return `1px solid ${theme.colors.neutral150}`;
    }
    if (expanded) {
        return `1px solid ${theme.colors.primary600}`;
    }
    if (variant === 'primary') {
        return `1px solid ${theme.colors.neutral0}`;
    }
    return `1px solid ${theme.colors.neutral100}`;
};
const AccordionTypography = styled(Typography) ``;
const AccordionWrapper = styled(Box) `
  border: ${getBorder};

  &:hover:not([aria-disabled='true']) {
    border: 1px solid ${({ theme }) => theme.colors.primary600};

    ${AccordionTypography} {
      color: ${({ theme, expanded }) => (expanded ? undefined : theme.colors.primary700)};
    }

    ${Typography} {
      color: ${({ theme, expanded }) => (expanded ? undefined : theme.colors.primary600)};
    }

    & > ${Flex} {
      background: ${({ theme }) => theme.colors.primary100};
    }

    [data-strapi-dropdown='true'] {
      background: ${({ theme }) => theme.colors.primary200};
    }
  }
`;
const Accordion = ({ children, disabled = false, error, expanded = false, hasErrorMessage = true, id, onToggle, toggle, size = 'M', variant = 'primary', shadow, }) => {
    const generatedId = useId(id);
    const context = React.useMemo(() => ({ expanded, onToggle, toggle, id: generatedId, size, variant, disabled }), [disabled, expanded, generatedId, onToggle, size, toggle, variant]);
    return (jsxs(AccordionContext.Provider, { value: context, children: [jsx(AccordionWrapper, { "data-strapi-expanded": expanded, disabled: disabled, "aria-disabled": disabled, expanded: expanded, hasRadius: true, variant: variant, error: error, shadow: shadow, children: children }), error && hasErrorMessage && (jsx(Box, { paddingTop: 1, children: jsx(Typography, { variant: "pi", textColor: "danger600", children: error }) }))] }));
};

export { Accordion, AccordionTypography };
