import { n as adminApi } from "./index-Sr5PWLEf.mjs";
const transferTokenService = adminApi.injectEndpoints({
  endpoints: (builder) => ({
    getTransferTokens: builder.query({
      query: () => ({
        url: "/admin/transfer/tokens",
        method: "GET"
      }),
      transformResponse: (response) => response.data,
      providesTags: (res, _err) => [
        ...res?.map(({ id }) => ({ type: "TransferToken", id })) ?? [],
        { type: "TransferToken", id: "LIST" }
      ]
    }),
    getTransferToken: builder.query({
      query: (id) => `/admin/transfer/tokens/${id}`,
      transformResponse: (response) => response.data,
      providesTags: (res, _err, id) => [{ type: "TransferToken", id }]
    }),
    createTransferToken: builder.mutation({
      query: (body) => ({
        url: "/admin/transfer/tokens",
        method: "POST",
        data: body
      }),
      transformResponse: (response) => response.data,
      invalidatesTags: [{ type: "TransferToken", id: "LIST" }]
    }),
    deleteTransferToken: builder.mutation({
      query: (id) => ({
        url: `/admin/transfer/tokens/${id}`,
        method: "DELETE"
      }),
      transformResponse: (response) => response.data,
      invalidatesTags: (_res, _err, id) => [{ type: "TransferToken", id }]
    }),
    updateTransferToken: builder.mutation({
      query: ({ id, ...body }) => ({
        url: `/admin/transfer/tokens/${id}`,
        method: "PUT",
        data: body
      }),
      transformResponse: (response) => response.data,
      invalidatesTags: (_res, _err, { id }) => [{ type: "TransferToken", id }]
    })
  }),
  overrideExisting: false
});
const {
  useGetTransferTokensQuery,
  useGetTransferTokenQuery,
  useCreateTransferTokenMutation,
  useDeleteTransferTokenMutation,
  useUpdateTransferTokenMutation
} = transferTokenService;
export {
  useCreateTransferTokenMutation as a,
  useUpdateTransferTokenMutation as b,
  useGetTransferTokensQuery as c,
  useDeleteTransferTokenMutation as d,
  useGetTransferTokenQuery as u
};
//# sourceMappingURL=transferTokens-nVplpXze.mjs.map
