/**
 * An object-oriented command-line parser for TypeScript projects.
 *
 * @packageDocumentation
 */
export { CommandLineAction, type ICommandLineActionOptions } from './providers/CommandLineAction';
export { DynamicCommandLineAction } from './providers/DynamicCommandLineAction';
export { ScopedCommandLineAction } from './providers/ScopedCommandLineAction';
export { AliasCommandLineAction, type IAliasCommandLineActionOptions } from './providers/AliasCommandLineAction';
export type { IBaseCommandLineDefinition, IBaseCommandLineDefinitionWithArgument, ICommandLineFlagDefinition, ICommandLineStringDefinition, ICommandLineStringListDefinition, ICommandLineIntegerDefinition, ICommandLineIntegerListDefinition, ICommandLineChoiceDefinition, ICommandLineChoiceListDefinition, ICommandLineRemainderDefinition } from './parameters/CommandLineDefinition';
export { CommandLineParameterKind, CommandLineParameter, CommandLineParameterWithArgument } from './parameters/BaseClasses';
export { CommandLineFlagParameter } from './parameters/CommandLineFlagParameter';
export { CommandLineStringParameter } from './parameters/CommandLineStringParameter';
export { CommandLineStringListParameter } from './parameters/CommandLineStringListParameter';
export { CommandLineIntegerParameter } from './parameters/CommandLineIntegerParameter';
export { CommandLineIntegerListParameter } from './parameters/CommandLineIntegerListParameter';
export { CommandLineChoiceParameter } from './parameters/CommandLineChoiceParameter';
export { CommandLineChoiceListParameter } from './parameters/CommandLineChoiceListParameter';
export { CommandLineRemainder } from './parameters/CommandLineRemainder';
export { CommandLineParameterProvider, type IScopedLongNameParseResult, type ICommandLineParserData as _ICommandLineParserData, type IRegisterDefinedParametersState as _IRegisterDefinedParametersState } from './providers/CommandLineParameterProvider';
export { CommandLineParser, type ICommandLineParserOptions } from './providers/CommandLineParser';
export { DynamicCommandLineParser } from './providers/DynamicCommandLineParser';
export { CommandLineConstants } from './Constants';
export { CommandLineHelper } from './CommandLineHelper';
//# sourceMappingURL=index.d.ts.map