// src/render.ts
import * as ReactDomServer from "react-dom/server";
import { convert } from "html-to-text";
import pretty from "pretty";
var render = (component, options) => {
  if (options == null ? void 0 : options.plainText) {
    return renderAsPlainText(component, options);
  }
  const doctype = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">';
  const markup = ReactDomServer.renderToStaticMarkup(component);
  const document = `${doctype}${markup}`;
  if (options && options.pretty) {
    return pretty(document);
  }
  return document;
};
var renderAsPlainText = (component, _options) => {
  return convert(ReactDomServer.renderToStaticMarkup(component), {
    selectors: [{ selector: "img", format: "skip" }]
  });
};
export {
  render
};
