import type { Faker } from '../../..';
/**
 * Module to generate links to random images on https://picsum.photos.
 *
 * The images generated from this module are fetched from an external service outside the control of Faker and could occasionally contain URLs which are broken or point to unexpected, disturbing, or offensive images. The service may also be subject to usage limits.
 *
 * @deprecated Use `faker.image.urlPicsumPhotos` instead.
 */
export declare class LoremPicsum {
    private readonly faker;
    constructor(faker: Faker);
    /**
     * Generates a new picsum photos image url.
     *
     * These images are fetched from an external service outside the control of Faker and could occasionally contain URLs which point to unexpected, disturbing, or offensive images. Usage limits may contribute to this behavior.
     *
     * @param width The width of the image. Defaults to `640`.
     * @param height The height of the image. Defaults to `480`.
     * @param grayscale Whether to return a grayscale image. Default to `false`.
     * @param blur The optional level of blur to apply. Supports `1` - `10`.
     *
     * @deprecated Use `faker.image.urlPicsumPhotos` instead.
     */
    image(width?: number, height?: number, grayscale?: boolean, blur?: 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10): string;
    /**
     * Generates a new picsum photos image url.
     *
     * These images are fetched from an external service outside the control of Faker and could occasionally contain URLs which point to unexpected, disturbing, or offensive images. Usage limits may contribute to this behavior.
     *
     * @param width The width of the image. Defaults to `640`.
     * @param height The height of the image. Defaults to `480`.
     * @param grayscale Whether to return a grayscale image. Default to `false`.
     *
     * @deprecated Use `faker.image.urlPicsumPhotos` instead.
     */
    imageGrayscale(width?: number, height?: number, grayscale?: boolean): string;
    /**
     * Generates a new picsum photos image url.
     *
     * These images are fetched from an external service outside the control of Faker and could occasionally contain URLs which point to unexpected, disturbing, or offensive images. Usage limits may contribute to this behavior.
     *
     * @param width The width of the image. Defaults to `640`.
     * @param height The height of the image. Defaults to `480`.
     * @param blur The optional level of blur to apply. Supports `1` - `10`.
     *
     * @deprecated Use `faker.image.urlPicsumPhotos` instead.
     */
    imageBlurred(width?: number, height?: number, blur?: 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10): string;
    /**
     * Generates a new picsum photos image url.
     *
     * These images are fetched from an external service outside the control of Faker and could occasionally contain URLs which point to unexpected, disturbing, or offensive images. Usage limits may contribute to this behavior.
     *
     * @param width The width of the image. Defaults to `640`.
     * @param height The height of the image. Defaults to `480`.
     * @param grayscale Whether to return a grayscale image. Default to `false`.
     * @param blur The optional level of blur to apply. Supports `1` - `10`.
     * @param seed The optional seed to use.
     *
     * @deprecated Use `faker.image.urlPicsumPhotos` instead.
     */
    imageRandomSeeded(width?: number, height?: number, grayscale?: boolean, blur?: 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10, seed?: string): string;
    /**
     * Generates a new picsum photos image url.
     *
     * These images are fetched from an external service outside the control of Faker and could occasionally contain URLs which point to unexpected, disturbing, or offensive images. Usage limits may contribute to this behavior.
     *
     * @param width The width of the image. Defaults to `640`.
     * @param height The height of the image. Defaults to `480`.
     * @param grayscale Whether to return a grayscale image. Default to `false`.
     * @param blur The optional level of blur to apply. Supports `1` - `10`.
     * @param seed The optional seed to use.
     *
     * @deprecated Use `faker.image.urlPicsumPhotos` instead.
     */
    imageUrl(width?: number, height?: number, grayscale?: boolean, blur?: 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8 | 9 | 10, seed?: string): string;
}
