import type { EmojiType, HTTPStatusCodeType } from '../modules/internet';
import type { LocaleEntry } from './definitions';
/**
 * The possible definitions related to internet stuff.
 */
export type InternetDefinition = LocaleEntry<{
    /**
     * Common top level and similar domains (e.g `de`, `co.uk`).
     */
    domain_suffix: string[];
    /**
     * Some email domains containing `example` (e.g. `example.com`).
     */
    example_email: string[];
    /**
     * Some free-mail domains used in that country (e.g. `gmail.de`).
     */
    free_email: string[];
    /**
     * List of all fully-qualified emojis.
     */
    emoji: Record<EmojiType, string[]>;
    /**
     * List of some HTTP status codes.
     */
    http_status_code: Record<HTTPStatusCodeType, number[]>;
}>;
