"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.shortNameToLongName = exports.getLastMonthShortName = exports.getCurrentMonthShortName = exports.lastMonthFilter = exports.thisMonthFilter = exports.normalizeKeys = exports.sumObjectValues = exports.getCompareTimeDifference = exports.getCompareTime = exports.getNinetyDaysAgo = exports.getDaysAgo = exports.getSixtyDaysAgo = exports.getStartOfPreviousMonth = exports.getThirtyDaysAgo = exports.getStartOfMonth = exports.getMonthNames = exports.getYearMonthsFromToday = exports.getTomorrow = exports.getMidnightToday = exports.getStartOfWeek = exports.isValidInteger = exports.getMonthsForYearFromDate = exports.sumByKey = exports.groupByNest = exports.groupBy = exports.arrayToObject = exports.getRandomValueFromArray = void 0;
const faker_1 = require("@faker-js/faker");
function getRandomValueFromArray(array) {
    const randomIndex = faker_1.faker.number.int({ min: 0, max: array.length - 1 });
    return array[randomIndex];
}
exports.getRandomValueFromArray = getRandomValueFromArray;
function arrayToObject(arr) {
    return arr.reduce((result, item) => {
        // const [key] = Object.keys(item);
        result = { ...item, ...result };
        return result;
    }, {});
}
exports.arrayToObject = arrayToObject;
// Recursive function to access nested properties
function getNestedValue(obj, key) {
    const keys = key.split(".");
    return keys.reduce((value, currentKey) => (value ? value[currentKey] : undefined), obj);
}
function groupBy(array, key) {
    return array.reduce((result, obj) => {
        const keyValue = obj[key];
        // If the key value is not present in the result, create an array for it
        if (!result[keyValue]) {
            result[keyValue] = [];
        }
        // Push the object to the array corresponding to the key value
        result[keyValue].push(obj);
        return result;
    }, {});
}
exports.groupBy = groupBy;
function groupByNest(array, key) {
    return array.reduce((result, obj) => {
        const keys = key.split(".");
        let nestedObj = obj;
        for (const nestedKey of keys) {
            if (nestedObj && nestedKey in nestedObj) {
                nestedObj = nestedObj[nestedKey];
            }
            else {
                nestedObj = undefined;
                break;
            }
        }
        const keyValue = nestedObj;
        // If the key value is not present in the result, create an array for it
        if (!result[keyValue]) {
            result[keyValue] = [];
        }
        // Push the object to the array corresponding to the key value
        result[keyValue].push(obj);
        return result;
    }, {});
}
exports.groupByNest = groupByNest;
// export function groupByNest<T>(array: T[], key: string): GroupedObject<T> {
//   return array.reduce((result, obj) => {
//     const keyValue = getNestedValue(obj, key) as string;
//
//     // If the key value is not present in the result, create an array for it
//     if (!result[keyValue]) {
//       result[keyValue] = [];
//     }
//
//     // Push the object to the array corresponding to the key value
//     result[keyValue].push(obj);
//
//     return result;
//   }, {} as GroupedObject<T>);
// }
function sumByKey(records, key) {
    return records.reduce((total, record) => total + +record[key], 0);
}
exports.sumByKey = sumByKey;
function getMonthsForYearFromDate(date) {
    const monthRanges = [];
    // Get the year and month from the provided date
    const year = date.getFullYear();
    const startMonth = date.getMonth();
    const dayOfMonth = 1; //date.getDate();
    // Iterate from the start month of the provided date to the same month of the previous year
    for (let month = startMonth; month >= 0; month--) {
        const startDate = new Date(year, month, dayOfMonth);
        let monthName = startDate.toLocaleString("en-US", { month: "short" });
        const endDate = new Date(year, month + 1, 0); // Last day of the current month
        monthRanges.push({ name: monthName, startDate, endDate });
    }
    // Add months from the previous year if necessary
    for (let month = 11; month > startMonth; month--) {
        const startDate = new Date(year - 1, month, dayOfMonth);
        let monthName = startDate.toLocaleString("en-US", { month: "short" });
        const endDate = new Date(year - 1, month + 1, 0); // Last day of the current month
        monthRanges.push({ name: monthName, startDate, endDate });
    }
    return monthRanges;
}
exports.getMonthsForYearFromDate = getMonthsForYearFromDate;
function isValidInteger(input) {
    const parsedValue = parseInt(input, 10);
    return !isNaN(parsedValue) && Number.isInteger(parsedValue);
}
exports.isValidInteger = isValidInteger;
function getStartOfWeek() {
    const today = new Date();
    const dayOfWeek = today.getDay(); // 0 is Sunday, 1 is Monday, and so on
    const startOfWeek = new Date(today);
    startOfWeek.setDate(today.getDate() - dayOfWeek + (dayOfWeek === 0 ? -6 : 1)); // Adjust for Sunday
    // Set the time to midnight
    startOfWeek.setHours(0, 0, 0, 0);
    return startOfWeek;
}
exports.getStartOfWeek = getStartOfWeek;
function getMidnightToday() {
    const today = new Date();
    return new Date(today.setHours(0, 0, 0, 0));
}
exports.getMidnightToday = getMidnightToday;
function getTomorrow() {
    const midnight = getMidnightToday();
    const tomorrow = new Date(midnight);
    tomorrow.setDate(midnight.getDate() + 1);
    return tomorrow;
}
exports.getTomorrow = getTomorrow;
function getYearMonthsFromToday() {
    const today = new Date();
    return getMonthsForYearFromDate(today);
}
exports.getYearMonthsFromToday = getYearMonthsFromToday;
function getMonthNames(yearMonths) {
    return yearMonths.map((it) => it.startDate.toLocaleString("en-US", { month: "short" }));
}
exports.getMonthNames = getMonthNames;
// export function getStartOfMonth() {
//   const today = new Date();
//   const startOfMonth = new Date(today.getFullYear(), today.getMonth(), 1);
//
//   // Set the time to midnight
//   startOfMonth.setHours(0, 0, 0, 0);
//
//   return startOfMonth;
// }
function getStartOfMonth() {
    const today = new Date();
    const startOfMonth = new Date(today.getFullYear(), today.getMonth(), 1);
    // Set the time to midnight
    startOfMonth.setHours(0, 0, 0, 0);
    return startOfMonth;
}
exports.getStartOfMonth = getStartOfMonth;
function getThirtyDaysAgo() {
    return new Date(new Date().setDate(new Date().getDate() - 30));
}
exports.getThirtyDaysAgo = getThirtyDaysAgo;
function getStartOfPreviousMonth() {
    const today = new Date();
    const firstDayOfCurrentMonth = new Date(today.getFullYear(), today.getMonth(), 1);
    const startOfLastMonth = new Date(firstDayOfCurrentMonth);
    // Set the month back by 1
    startOfLastMonth.setMonth(firstDayOfCurrentMonth.getMonth() - 1);
    // Set the time to midnight
    startOfLastMonth.setHours(0, 0, 0, 0);
    return startOfLastMonth;
}
exports.getStartOfPreviousMonth = getStartOfPreviousMonth;
function getSixtyDaysAgo() {
    return new Date(new Date().setDate(new Date().getDate() - 60));
}
exports.getSixtyDaysAgo = getSixtyDaysAgo;
function getDaysAgo(days) {
    return new Date(new Date().setDate(new Date().getDate() - days));
}
exports.getDaysAgo = getDaysAgo;
function getNinetyDaysAgo() {
    return getDaysAgo(90);
}
exports.getNinetyDaysAgo = getNinetyDaysAgo;
function getCompareTime() {
    const now = new Date();
    const hour = now.getHours().toString().padStart(2, "0");
    const minute = now.getMinutes().toString().padStart(2, "0");
    const second = now.getSeconds().toString().padStart(2, "0");
    const millisecond = now.getMilliseconds().toString().padStart(3, "0");
    return `${hour}:${minute}:${second}:${millisecond}`;
}
exports.getCompareTime = getCompareTime;
function getCompareTimeDifference(endTime) {
    const elapsedNanoseconds = endTime[0] * 1e9 + endTime[1];
    return elapsedNanoseconds;
}
exports.getCompareTimeDifference = getCompareTimeDifference;
/*
 *sums all values integer in object
 */
function sumObjectValues(obj) {
    return Object.values(obj).reduce((sum, value) => {
        if (typeof value == "number") {
            return sum + value;
        }
    }, 0);
}
exports.sumObjectValues = sumObjectValues;
function normalizeKeys(obj) {
    const normalizedObj = {};
    for (const key in obj) {
        const normalizedKey = key.replace(/\s+/g, "").toLowerCase();
        normalizedObj[normalizedKey] = obj[key];
    }
    return normalizedObj;
}
exports.normalizeKeys = normalizeKeys;
function thisMonthFilter() {
    return {
        $gte: getStartOfMonth(),
    };
}
exports.thisMonthFilter = thisMonthFilter;
function lastMonthFilter() {
    return {
        $lte: getStartOfMonth(),
        $gte: getStartOfPreviousMonth(),
    };
}
exports.lastMonthFilter = lastMonthFilter;
function getCurrentMonthShortName() {
    const date = new Date();
    return date.toLocaleString('en-US', { month: 'short' });
}
exports.getCurrentMonthShortName = getCurrentMonthShortName;
function getLastMonthShortName() {
    const date = new Date();
    date.setMonth(date.getMonth() - 1);
    return date.toLocaleString('en-US', { month: 'short' });
}
exports.getLastMonthShortName = getLastMonthShortName;
function shortNameToLongName(shortName) {
    const monthNames = {
        'Jan': 'January',
        'Feb': 'February',
        'Mar': 'March',
        'Apr': 'April',
        'May': 'May',
        'Jun': 'June',
        'Jul': 'July',
        'Aug': 'August',
        'Sep': 'September',
        'Oct': 'October',
        'Nov': 'November',
        'Dec': 'December'
    };
    return monthNames[shortName];
}
exports.shortNameToLongName = shortNameToLongName;
console.log(shortNameToLongName('Jan')); // Outputs: January
console.log(shortNameToLongName('Sep')); // Outputs: September
