"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateDummyData = void 0;
const helpers_js_1 = require("./helpers.js");
const faker_1 = require("@faker-js/faker");
async function generateDummyData(strapi) {
    let numberOfCampuses = await strapi.entityService.count("api::campus.campus");
    let numberOfNetworks = await strapi.entityService.count("api::network.network");
    let adminroles = await strapi.entityService.findMany("admin::role");
    if (false) {
        for (let i = 0; i < 100; i++) {
            let date = new Date();
            await strapi.entityService.create("api::event.event", {
                data: {
                    name: faker_1.faker.lorem.sentence(),
                    startTime: date,
                    endTime: faker_1.faker.date.future({ refDate: date }),
                    location: faker_1.faker.location.street(),
                    description: faker_1.faker.lorem.paragraphs(1),
                    associatedMembers: [faker_1.faker.number.int({ min: 1, max: 1000 })],
                },
            });
        }
    }
    if (false) {
        let campuses = await strapi.entityService.findMany("api::campus.campus", {
            populate: "*",
        });
        let campusIds = campuses.map((campus) => ({ id: campus.id }));
        let zones = await strapi.entityService.findMany("api::zone.zone", {
            populate: "*",
        });
        let zoneIds = zones.map((zone) => ({ id: zone.id }));
        let cidx = 0;
        while (cidx < campusIds.length) {
            let idx = cidx * 6;
            for (let i = idx; i < idx + 6; i++) {
                let zone = await strapi.entityService.update("api::zone.zone", zoneIds[i].id, {
                    data: {
                        campus: campusIds[cidx].id,
                    },
                });
            }
            cidx++;
        }
        console.log("Did the zones thing");
    }
    if (numberOfNetworks != 5) {
        await strapi.entityService.create("api::data-config.data-config", {
            data: {
                pastoralRoles: "Senior Pastor,Executive Pastor,Network Leader,Campus Pastor,Ministry Assistant",
                staffRoles: "Intern,Associate",
                publishedAt: "2024-01-18T21:15:27.422Z",
            },
        });
        await strapi.entityService.create("plugin::users-permissions.role", {
            data: {
                description: "Gives Network Level Access",
                name: "Network Access",
            },
        });
        await strapi.entityService.create("plugin::users-permissions.role", {
            data: {
                description: "Gives Campus Level Access",
                name: "Campus Access",
            },
        });
        await strapi.entityService.create("plugin::users-permissions.role", {
            data: {
                description: "Gives Organisation Level Access",
                name: "Organisation Access",
            },
        });
        await strapi.entityService.create("plugin::users-permissions.role", {
            data: {
                description: "Gives Forms Level Access",
                name: "Forms Access",
            },
        });
        console.log("Created roles");
        let nets = [
            {
                publishedAt: new Date(),
                name: "Downtown",
                colors: {
                    bg: "#FFEBEB",
                    text: "#DA0000",
                },
                bg: "#FFEBEB",
                text: "#DA0000",
                chartBg: "#F88507",
            },
            {
                publishedAt: new Date(),
                name: "Mashariki",
                colors: {
                    bg: "#EBFFEB",
                    text: "#004700",
                },
                bg: "#EBFFEB",
                text: "#004700",
                chartBg: "#0EB7F1",
            },
            {
                publishedAt: new Date(),
                name: "South",
                colors: {
                    bg: "#FAFEEC",
                    text: "#2A3300",
                },
                bg: "#FAFEEC",
                text: "#2A3300",
                chartBg: "#68BE41",
            },
            {
                publishedAt: new Date(),
                name: "Hillcity",
                colors: {
                    bg: "#383838",
                    text: "#FFFFFF",
                },
                bg: "#383838",
                text: "#FFFFFF",
                chartBg: "#6C42BD",
            },
            {
                publishedAt: new Date(),
                name: "Lifeway",
                colors: {
                    bg: "#EBEEFE",
                    text: "#0827F7",
                },
                bg: "#EBEEFE",
                text: "#0827F7",
                chartBg: "#C13E8B",
            },
        ];
        for (let i = 0; i < nets.length; i++) {
            await strapi.entityService.create("api::network.network", {
                data: nets[i],
            });
        }
        console.log("Created Networks");
        await strapi.entityService.create("admin::user", {
            data: {
                username: process.env.ADMIN_USERNAME,
                email: process.env.ADMIN_EMAIL,
                password: process.env.ADMIN_PASSWORD,
                firstname: process.env.ADMIN_FIRSTNAME,
                lastname: process.env.ADMIN_LASTNAME,
                isActive: true,
                roles: adminroles.map((role) => role.id),
            },
        });
        let userRoles = await strapi.entityService.findMany("plugin::users-permissions.role");
        function creatUserEmail(rolename) {
            let firstpart = rolename.split(" ")[0].toLowerCase();
            return firstpart + "@mavuno.org";
        }
        function creatUserPassword(rolename) {
            let firstpart = rolename.split(" ")[0].toLowerCase();
            return firstpart + "pass1234";
        }
        function createFirstName(rolename) {
            let firstpart = rolename.split(" ")[0].toLowerCase();
            return firstpart;
        }
        console.log("Now creating users");
        console.log(userRoles.length);
        for (let i = 0; i < userRoles.length; i++) {
            let role = userRoles[i];
            console.log(role.name);
            console.log(creatUserEmail(role.name));
            console.log(creatUserPassword(role.name));
            console.log(createFirstName(role.name));
            await strapi.entityService.create("plugin::users-permissions.user", {
                data: {
                    username: createFirstName(role.name) + "username",
                    email: creatUserEmail(role.name),
                    password: creatUserPassword(role.name),
                    firstname: createFirstName(role.name),
                    isActive: true,
                    role: role.id,
                    confirmed: true,
                    provider: "local",
                },
            });
        }
        console.log("Created Pannel Users");
    }
    if (numberOfCampuses < 20) {
        const naiLat = () => faker_1.faker.location.latitude({ min: -1.45, max: -1.15 }).toString();
        const naiLong = () => faker_1.faker.location.longitude({ min: 36.65, max: 37.05 }).toString();
        let networkIds = await strapi
            .query("api::network.network")
            .findMany()
            .then((elements) => {
            return elements.map((element) => element.id);
        });
        // generate sample campuses
        for (let index = 0; index < 21; index++) {
            await strapi.entityService.create("api::campus.campus", {
                data: {
                    publishedAt: new Date(),
                    name: faker_1.faker.location.city(),
                    location: faker_1.faker.location.street(),
                    network: (0, helpers_js_1.getRandomValueFromArray)(networkIds),
                    coordinates: {
                        lat: naiLat(),
                        long: naiLong(),
                    },
                },
            });
        }
        console.log("Created Campuses");
        let campuses = [];
        for (let index = 0; index < networkIds.length; index++) {
            let campusInfo = await strapi
                .query("api::campus.campus")
                .findMany({
                where: {
                    network: {
                        id: {
                            $eq: networkIds[index],
                        },
                    },
                },
                populate: true,
            })
                .then((elements) => {
                return elements.map((element) => ({
                    id: element.id,
                    network: networkIds[index],
                    zones: [],
                    cohorts: [],
                }));
            });
            campuses.push(campusInfo);
        }
        let campusIds = campuses.flat();
        console.log(campusIds);
        // generate sample members
        for (let cidx = 0; cidx < campusIds.length; cidx++) {
            for (let index = 0; index < 80; index++) {
                await strapi.entityService.create("api::member.member", {
                    data: {
                        createdAt: faker_1.faker.date.past({ years: 1 }),
                        publishedAt: new Date(),
                        name: faker_1.faker.person.fullName(),
                        gender: (0, helpers_js_1.getRandomValueFromArray)(["Male", "Female"]),
                        dateOfBirth: faker_1.faker.date.birthdate(),
                        spouse: faker_1.faker.person.fullName(),
                        maritalStatus: (0, helpers_js_1.getRandomValueFromArray)(["Married", "Single"]),
                        pastoralRole: (0, helpers_js_1.getRandomValueFromArray)([
                            "Campus Pastor",
                            "Network Leader",
                            "Senior Pastor",
                            "Executive Pastor",
                            "Ministry Assistant",
                        ]),
                        isStaff: faker_1.faker.datatype.boolean(),
                        isPastoralMember: faker_1.faker.datatype.boolean(),
                        staffRole: "Intern",
                        campus: campusIds[cidx].id,
                        network: campusIds[cidx].network,
                        contact: {
                            phone: faker_1.faker.string.numeric(10),
                            email: faker_1.faker.internet.email(),
                        },
                        studentInfo: {
                            studentId: faker_1.faker.string.uuid(),
                            institutionName: faker_1.faker.company.name(),
                        },
                        emergencyContact: {
                            name: faker_1.faker.person.fullName(),
                            phone: faker_1.faker.string.numeric(10),
                        },
                    },
                });
            }
        }
        console.log("Created Members");
        for (let i = 0; i < campusIds.length; i++) {
            let members = await strapi.entityService.findMany("api::member.member");
            await strapi.entityService.update("api::campus.campus", campusIds[i].id, {
                data: {
                    pastor: faker_1.faker.number.int({ min: 1, max: 1000 }),
                },
            });
        }
        for (let i = 1; i < 6; i++) {
            await strapi.entityService.update("api::network.network", i, {
                data: {
                    pastor: faker_1.faker.number.int({ min: 1, max: 1000 }),
                },
            });
        }
        console.log("Assigned Pastors");
        // generate sample zones
        for (let cidx = 0; cidx < campusIds.length; cidx++) {
            for (let i = 0; i < 6; i++) {
                let zone = await strapi.entityService.create("api::zone.zone", {
                    data: {
                        campus: campusIds[cidx].id,
                        network: campusIds[cidx].network,
                        name: faker_1.faker.location.city() + " Zone",
                        publishedAt: new Date(),
                        coordinates: {
                            lat: naiLat(),
                            long: naiLong(),
                        },
                        zone_leader: (0, helpers_js_1.getRandomValueFromArray)(await strapi.entityService.findMany("api::member.member", {
                            filters: {
                                campus: {
                                    id: {
                                        $eq: campusIds[cidx].id,
                                    },
                                },
                            },
                        })).id,
                    },
                });
                campusIds[cidx].zones.push({
                    id: +zone.id,
                });
            }
        }
        console.log("Created Zones");
        // function to return an array of 8 members in the campus to allocate to a discipleshipGroup in in the campus
        async function getMembersWithoutDg(campus) {
            let members = [];
            for (let i = 0; i < 8; i++) {
                let likely = await strapi.entityService.findMany("api::member.member", {
                    filters: {
                        campus: {
                            id: {
                                $eq: campus.id,
                            },
                        },
                        discipleshipGroup: {
                            id: {
                                $null: true,
                            },
                        },
                    },
                });
                members.push((0, helpers_js_1.getRandomValueFromArray)(likely).id);
            }
            return members;
        }
        // generate sample discipleship groups
        //  let dgInfo = [];
        for (let cidx = 0; cidx < campusIds.length; cidx++) {
            // create dg for every zone
            for (let zidx = 0; zidx < campusIds[cidx].zones.length; zidx++) {
                let dg = await strapi.entityService.create("api::discipleship-group.discipleship-group", {
                    data: {
                        name: faker_1.faker.location.county() + " Discipleship Group",
                        campus: campusIds[cidx].id,
                        network: campusIds[cidx].network,
                        zone: campusIds[cidx].zones[zidx].id,
                        publishedAt: new Date(),
                        coordinates: {
                            lat: naiLat(),
                            long: naiLong(),
                        },
                        dgleader: faker_1.faker.number.int({ min: 1, max: 1000 }),
                        members: await getMembersWithoutDg(campusIds[cidx]),
                    },
                });
                // dgInfo.push(dg);
                //
                for (let i = 0; i < 12; i++) {
                    let attendance = await strapi.entityService.create("api::dg-attendance.dg-attendance", {
                        data: {
                            date: faker_1.faker.date.past({ years: 1 }),
                            discipleshipGroup: dg.id,
                            total: faker_1.faker.number.int({ min: 1, max: 12 }),
                            network: campusIds[cidx].network,
                            campus: campusIds[cidx].id,
                            publishedAt: new Date(),
                        },
                    });
                }
            }
        }
        console.log("Created Dgs and linked to members");
        for (let i = 0; i < 100; i++) {
            let date = faker_1.faker.date.past({ years: 1 });
            await strapi.entityService.create("api::event.event", {
                data: {
                    publishedAt: new Date(),
                    name: faker_1.faker.lorem.sentence(),
                    startTime: date,
                    endTime: faker_1.faker.date.future({ refDate: date }),
                    location: faker_1.faker.location.street(),
                    description: faker_1.faker.lorem.paragraphs(1),
                    associatedMembers: [
                        faker_1.faker.number.int({ min: 1, max: 1000 }),
                        faker_1.faker.number.int({ min: 1, max: 1000 }),
                        faker_1.faker.number.int({ min: 1, max: 1000 }),
                        faker_1.faker.number.int({ min: 1, max: 1000 }),
                        faker_1.faker.number.int({ min: 1, max: 1000 }),
                    ],
                },
            });
        }
        console.log("Created Events");
        for (let cidx = 0; cidx < campusIds.length; cidx++) {
            let theCampus = campusIds[cidx].id;
            let theNetwork = campusIds[cidx].network;
            console.log("Created Stats for Campus with id ", theCampus, `Progress :: ${cidx + 1}/${campusIds.length}`);
            for (let index = 0; index < 28; index++) {
                // for mavuno givings
                await strapi.entityService.create("api::mavuno-giving.mavuno-giving", {
                    data: {
                        network: theNetwork,
                        campus: theCampus,
                        date: faker_1.faker.date.past({ years: 1 }),
                        publishedAt: new Date(),
                        pdq: faker_1.faker.number.int(30000),
                        usd: faker_1.faker.number.int(2000),
                        cash: faker_1.faker.number.int(200000),
                        mpesa: faker_1.faker.number.int(200000),
                        total: faker_1.faker.number.int(450000),
                        cheques: faker_1.faker.number.int(20000),
                        type: (0, helpers_js_1.getRandomValueFromArray)([
                            "Offering",
                            "Tithe",
                            "First fruits",
                        ]),
                    },
                });
                await strapi.entityService.create("api::mavuno-giving.mavuno-giving", {
                    data: {
                        network: theNetwork,
                        campus: theCampus,
                        date: faker_1.faker.date.past({ years: 1 }),
                        publishedAt: new Date(),
                        pdq: faker_1.faker.number.int(30000),
                        usd: faker_1.faker.number.int(2000),
                        cash: faker_1.faker.number.int(200000),
                        mpesa: faker_1.faker.number.int(200000),
                        total: faker_1.faker.number.int(450000),
                        cheques: faker_1.faker.number.int(20000),
                        type: (0, helpers_js_1.getRandomValueFromArray)([
                            "Offering",
                            "Tithe",
                            "First fruits",
                        ]),
                    },
                });
                await strapi.entityService.create("api::money-allocation.money-allocation", {
                    data: {
                        publishedAt: new Date(),
                        campus: theCampus,
                        network: theNetwork,
                        amount: faker_1.faker.number.int({ min: 2000, max: 100000 }),
                        intendedUse: faker_1.faker.lorem.paragraph(1),
                        date: faker_1.faker.date.past({ years: 1 }),
                    },
                });
                await strapi.entityService.create("api::money-allocation.money-allocation", {
                    data: {
                        publishedAt: new Date(),
                        campus: theCampus,
                        network: theNetwork,
                        amount: faker_1.faker.number.int({ min: 2000, max: 100000 }),
                        intendedUse: faker_1.faker.lorem.paragraph(1),
                        date: faker_1.faker.date.past({ years: 1 }),
                    },
                });
                await strapi.entityService.create("api::expense.expense", {
                    data: {
                        publishedAt: new Date(),
                        campus: theCampus,
                        network: theNetwork,
                        amount: faker_1.faker.number.int({ min: 2000, max: 50000 }),
                        appovedBy: faker_1.faker.number.int({ min: 1, max: 1000 }),
                        description: faker_1.faker.lorem.paragraph(1),
                        date: faker_1.faker.date.past({ years: 1 }),
                    },
                });
                await strapi.entityService.create("api::expense.expense", {
                    data: {
                        publishedAt: new Date(),
                        campus: theCampus,
                        network: theNetwork,
                        amount: faker_1.faker.number.int({ min: 2000, max: 50000 }),
                        appovedBy: faker_1.faker.number.int({ min: 1, max: 1000 }),
                        description: faker_1.faker.lorem.paragraph(1),
                        date: faker_1.faker.date.past({ years: 1 }),
                    },
                });
                // sample baptism
                await strapi.entityService.create("api::baptism.baptism", {
                    data: {
                        campus: theCampus,
                        network: theNetwork,
                        publishedAt: new Date(),
                        kids: faker_1.faker.number.int(100),
                        teens: faker_1.faker.number.int(200),
                        adults: faker_1.faker.number.int(200),
                        total: faker_1.faker.number.int({ min: 500, max: 1200 }),
                    },
                });
                // for campus trend
                await strapi.entityService.create("api::campus-trend.campus-trend", {
                    data: {
                        total: faker_1.faker.number.int({ min: 700, max: 1200 }),
                        campus: theCampus,
                        network: theNetwork,
                        male: faker_1.faker.number.int(380),
                        female: faker_1.faker.number.int(700),
                        publishedAt: new Date(),
                        date: faker_1.faker.date.past({ years: 1 }),
                        visitors: faker_1.faker.number.int(100),
                    },
                });
                await strapi.entityService.create("api::rope.rope", {
                    data: {
                        campus: theCampus,
                        network: theNetwork,
                        teens: faker_1.faker.number.int(380),
                        adults: faker_1.faker.number.int(700),
                        publishedAt: new Date(),
                        date: faker_1.faker.date.past({ years: 1 }),
                    },
                });
                // sample zetch data
                await strapi.entityService.create("api::zetech-campus.zetech-campus", {
                    data: {
                        date: faker_1.faker.date.past({ years: 1 }),
                        campus: theCampus,
                        network: theNetwork,
                        male: faker_1.faker.number.int(4000),
                        female: faker_1.faker.number.int(5000),
                        visitors: faker_1.faker.number.int(2000),
                        publishedAt: new Date(),
                    },
                });
                //for statehouse-school
                await strapi.entityService.create("api::statehouse-school.statehouse-school", {
                    data: {
                        date: faker_1.faker.date.past({ years: 1 }),
                        publishedAt: new Date(),
                        attendance: faker_1.faker.number.int(280),
                    },
                });
                for (let index = 0; index < 4; index++) {
                    // for services-tracker-form
                    await strapi.entityService.create("api::services-tracker-form.services-tracker-form", {
                        data: {
                            date: faker_1.faker.date.past({ years: 1 }),
                            campus: theCampus,
                            network: theNetwork,
                            total: faker_1.faker.number.int({ min: 1000, max: 10000 }),
                            publishedAt: new Date(),
                            firstService: {
                                kidsInService: faker_1.faker.number.int({ min: 100, max: 700 }),
                                salvations: faker_1.faker.number.int({ min: 100, max: 700 }),
                                mavunoKids: faker_1.faker.number.int({ min: 100, max: 700 }),
                                myf: faker_1.faker.number.int({ min: 200, max: 700 }),
                                myfAdults: faker_1.faker.number.int({ min: 40, max: 700 }),
                                adultsInKids: faker_1.faker.number.int({ min: 20, max: 700 }),
                                adultsInService: faker_1.faker.number.int({ min: 200, max: 700 }),
                                visitorsInService: faker_1.faker.number.int({ min: 50, max: 400 }),
                            },
                            secondService: {
                                kidsInService: faker_1.faker.number.int({ min: 100, max: 700 }),
                                salvations: faker_1.faker.number.int({ min: 100, max: 700 }),
                                mavunoKids: faker_1.faker.number.int({ min: 100, max: 700 }),
                                myf: faker_1.faker.number.int({ min: 200, max: 700 }),
                                myfAdults: faker_1.faker.number.int({ min: 40, max: 700 }),
                                adultsInKids: faker_1.faker.number.int({ min: 20, max: 700 }),
                                adultsInService: faker_1.faker.number.int({ min: 200, max: 700 }),
                                visitorsInService: faker_1.faker.number.int({ min: 50, max: 400 }),
                            },
                        },
                    });
                }
                let startDate = faker_1.faker.date.past({ years: 1 });
                //for  cohorts
                let cohort = await strapi.entityService.create("api::cohort.cohort", {
                    data: {
                        publishedAt: new Date(),
                        name: faker_1.faker.location.street() + " Cohort " + cidx,
                        Group: (0, helpers_js_1.getRandomValueFromArray)(["Ndoa", "Lea", "Mizizi"]),
                        progress: (0, helpers_js_1.getRandomValueFromArray)(["Running", "Completed"]),
                        startDate: startDate,
                        endDate: faker_1.faker.date.future({ refDate: startDate }),
                    },
                });
                campusIds[cidx].cohorts.push({ id: +cohort.id });
                // for the mavuno experiences
                for (let count = 0; count < 15; count++) {
                    await strapi.entityService.create("api::lea.lea", {
                        data: {
                            date: faker_1.faker.date.past({ years: 1 }),
                            campus: theCampus,
                            network: theNetwork,
                            cohort: cohort.id,
                            parentsAttendance: faker_1.faker.number.int({ min: 20, max: 40 }),
                            publishedAt: new Date(),
                        },
                    });
                    await strapi.entityService.create("api::mizizi.mizizi", {
                        data: {
                            date: faker_1.faker.date.past({ years: 1 }),
                            campus: theCampus,
                            network: theNetwork,
                            cohort: cohort.id,
                            publishedAt: new Date(),
                            onlineAttendance: faker_1.faker.number.int(300),
                            eveningAttendance: faker_1.faker.number.int(300),
                            morningAttendance: faker_1.faker.number.int(300),
                        },
                    });
                    await strapi.entityService.create("api::ndoa.ndoa", {
                        data: {
                            date: faker_1.faker.date.past({ years: 1 }),
                            campus: theCampus,
                            network: theNetwork,
                            cohort: cohort.id,
                            publishedAt: new Date(),
                            couplesNumber: faker_1.faker.number.int(200),
                        },
                    });
                }
            }
        }
        console.log("Dummy Data Created Successfully \n \n \n ");
    }
}
exports.generateDummyData = generateDummyData;
