"use strict";
/**
 * format-data policy
 */
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateResultsArray = exports.singleItemResult = exports.capitalize = void 0;
exports.default = (policyContext, config, { strapi }) => {
    // Add your own logic here.
    strapi.log.info("In format-data policy.");
    const canDoSomething = true;
    if (canDoSomething) {
        return true;
    }
    return false;
};
let PUBLIC_STRAPI_URL = (_a = process.env.PUBLIC_STRAPI_URL) !== null && _a !== void 0 ? _a : "";
function capitalize(str) {
    if (str.includes(" ")) {
        return str.split(" ").reduce((prev, curr) => {
            curr = curr.charAt(0).toUpperCase() + curr.substring(1).toLowerCase();
            return `${prev} ${curr}`;
        }, "");
    }
    else {
        return str.charAt(0).toUpperCase() + str.substring(1).toLowerCase();
    }
}
exports.capitalize = capitalize;
function singleItemResult(item) {
    const toConvert = { data: [item.data] };
    const converted = generateResultsArray(toConvert);
    return converted[0];
}
exports.singleItemResult = singleItemResult;
function generateResultsArray(res) {
    var _a;
    let response = res;
    const result = [];
    let keys = [];
    if ((response === null || response === void 0 ? void 0 : response.data) && (response === null || response === void 0 ? void 0 : response.data.length) > 0) {
        keys = Object.keys((_a = response.data[0]) === null || _a === void 0 ? void 0 : _a.attributes);
        keys = keys.filter((key) => ![
            "locale",
            "localizations",
            "provider",
            "provider_metadata",
            "publishedAt",
            "createdAt",
            "updatedAt",
        ].includes(key));
        const baseArray = response.data;
        if (Array.isArray(baseArray)) {
            baseArray.forEach((item) => {
                const resultItem = {};
                resultItem.id = item.id;
                keys.forEach((key) => {
                    var _a, _b, _c;
                    if ((_a = item === null || item === void 0 ? void 0 : item.attributes[key]) === null || _a === void 0 ? void 0 : _a.data) {
                        const it = item.attributes[key];
                        if ((_c = (_b = it.data[0]) === null || _b === void 0 ? void 0 : _b.attributes) === null || _c === void 0 ? void 0 : _c.url) {
                            // const formats = it.data[0]?.attributes?.formats;
                            // if (formats) {
                            // 	console.log('hhhere', formats);
                            // 	resultItem[key] = unwrapImages(it);
                            // } else {
                            // 	resultItem[key] = unwrapFiles(it);
                            // }
                            resultItem[key] = unwrapFilesAndImages(it);
                        }
                        else if (Array.isArray(item === null || item === void 0 ? void 0 : item.attributes[key].data)) {
                            resultItem[key] = generateResultsArray(item.attributes[key]);
                        }
                        else if (typeof item.attributes[key].data == "object") {
                            resultItem[key] = {
                                id: item.attributes[key].data.id,
                                ...item.attributes[key].data.attributes,
                            };
                        }
                    }
                    else {
                        if (key === "name" || key === "title") {
                            resultItem[key] = capitalize(item.attributes[key]).trim();
                        }
                        else {
                            resultItem[key] = item.attributes[key];
                        }
                    }
                });
                result.push(resultItem);
            });
        }
    }
    return result;
}
exports.generateResultsArray = generateResultsArray;
function unwrapImages(input) {
    const serverResponse = input.data;
    const result = serverResponse.map(({ id, attributes }) => {
        const item = {
            id: id,
            alternativeText: attributes.alternativeText,
            caption: attributes.caption,
            ext: attributes.ext,
            formats: {
                small: {
                    height: attributes.formats.small.height,
                    size: attributes.formats.small.size,
                    url: PUBLIC_STRAPI_URL + attributes.formats.small.url,
                    width: attributes.formats.small.width,
                },
                thumbnail: {
                    height: attributes.formats.thumbnail.height,
                    size: attributes.formats.thumbnail.size,
                    url: PUBLIC_STRAPI_URL + attributes.formats.thumbnail.url,
                    width: attributes.formats.thumbnail.width,
                },
            },
            height: attributes.height,
            mime: attributes.mime,
            name: attributes.name,
            width: attributes.width,
            size: attributes.size,
            url: PUBLIC_STRAPI_URL + attributes.url,
        };
        return item;
    });
    return result;
}
function unwrapFiles(files) {
    const serverResponse = files.data;
    const result = serverResponse.map(({ id, attributes }) => {
        const item = {
            id: id,
            alternativeText: attributes.alternativeText || "",
            caption: attributes.caption || "",
            ext: attributes.ext,
            mime: attributes.mime,
            name: attributes.name,
            size: attributes.size,
            url: PUBLIC_STRAPI_URL + attributes.url,
        };
        return item;
    });
    return result;
}
function unwrapFilesAndImages(it) {
    const serverResponse = it.data;
    const resultItem = serverResponse.map(({ id, attributes }) => {
        let item = {};
        if (attributes.formats) {
            item = {
                id: id,
                alternativeText: attributes.alternativeText,
                caption: attributes.caption,
                ext: attributes.ext,
                formats: {
                    small: {
                        height: attributes.formats.small.height,
                        size: attributes.formats.small.size,
                        url: PUBLIC_STRAPI_URL + attributes.formats.small.url,
                        width: attributes.formats.small.width,
                    },
                    thumbnail: {
                        height: attributes.formats.thumbnail.height,
                        size: attributes.formats.thumbnail.size,
                        url: PUBLIC_STRAPI_URL + attributes.formats.thumbnail.url,
                        width: attributes.formats.thumbnail.width,
                    },
                },
                height: attributes.height,
                mime: attributes.mime,
                name: attributes.name,
                width: attributes.width,
                size: attributes.size,
                url: PUBLIC_STRAPI_URL + attributes.url,
            };
        }
        else {
            item = {
                id: id,
                alternativeText: attributes.alternativeText || "",
                caption: attributes.caption || "",
                ext: attributes.ext,
                mime: attributes.mime,
                name: attributes.name,
                size: attributes.size,
                url: PUBLIC_STRAPI_URL + attributes.url,
            };
        }
        return item;
    });
    return resultItem;
}
