"use strict";
/**
 * `format-data` middleware
 */
Object.defineProperty(exports, "__esModule", { value: true });
const format_data_1 = require("../policies/format-data");
const campus_1 = require("../api/campus/controllers/campus");
exports.default = (config, { strapi }) => {
    // Add your own logic here.
    return async (ctx, next) => {
        await next();
        if (ctx.request.host != ctx.request.origin) {
            ctx.response.body = {
                data: Array.isArray(ctx.response.body.data)
                    ? (0, format_data_1.generateResultsArray)(ctx.response.body)
                    : (0, format_data_1.singleItemResult)(ctx.response.body),
                meta: ctx.response.body.meta,
            };
            ctx.response.body = (0, campus_1.omitFieldsRecursively)(ctx.response.body);
        }
    };
};
