"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const generateDummmyData_js_1 = require("./utils/generateDummmyData.js");
exports.default = {
    /**
     * An asynchronous register function that runs before
     * your application is initialized.
     *
     * This gives you an opportunity to extend code.
     */
    register( /*{ strapi }*/) { },
    /**
     * An asynchronous bootstrap function that runs before
     * your application gets started.
     *
     * This gives you an opportunity to set up your data model,
     * run jobs, or perform some special logic.
     */
    async bootstrap({ strapi }) {
        try {
            await (0, generateDummmyData_js_1.generateDummyData)(strapi);
        }
        catch (error) {
            console.log(error);
        }
    },
};
