"use strict";
/**
 * services-tracker-form controller
 */
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::services-tracker-form.services-tracker-form", ({ strapi }) => ({
    async create(ctx) {
        const { data } = ctx.request.body;
        if (typeof data.firstService === "object") {
            return super.create(ctx);
            // const res = await strapi.entityService.create(
            //   "api::services-tracker-form.services-tracker-form",
            //   {
            //     data,
            //   }
            // );
            // ctx.response.status = 201;
            // ctx.response.body = res;
            // return res;
        }
        const nestedData = nestServiceData(ctx.request.body);
        const servicesTrackerForm = await strapi.entityService.create("api::services-tracker-form.services-tracker-form", {
            data: {
                ...nestedData.data,
            },
        });
        const givingdata = {
            ...data,
            total: data.givingTotal,
            campus: [data.campus],
            network: [data.network],
            publishedAt: new Date(),
        };
        console.log(givingdata);
        const givings = await strapi.entityService.create("api::mavuno-giving.mavuno-giving", {
            data: {
                ...givingdata,
            },
        });
        ctx.response.status = 201;
        ctx.response.body = { data: { services: servicesTrackerForm, givings } };
        return servicesTrackerForm;
    },
}));
function nestServiceData(input) {
    console.log(input.data);
    const nestedData = {
        data: {
            firstService: {
                adultsInService: input.data.firstServiceAdultsInService,
                kidsInService: input.data.firstServiceKidsInService,
                visitorsInService: input.data.firstServiceVisitorsInService,
                salvations: input.data.firstServiceSalvations,
                mavunoKids: input.data.firstServiceMavunoKids,
                adultsInKids: input.data.firstServiceAdultsInKids,
                myf: input.data.firstServiceMyf,
                myfAdults: input.data.firstServiceMyfAdults,
            },
            secondService: {
                adultsInService: input.data.secondServiceAdultsInService,
                kidsInService: input.data.secondServiceKidsInService,
                visitorsInService: input.data.secondServiceVisitorsInService,
                salvations: input.data.secondServiceSalvations,
                mavunoKids: input.data.secondServiceMavunoKids,
                adultsInKids: input.data.secondServiceAdultsInKids,
                myf: input.data.secondServiceMmyf,
                myfAdults: input.data.secondServiceMyfAdults,
            },
            date: input.data.date,
            campus: [input.data.campus],
            total: input.data.serviceTotal,
            network: [input.data.network],
            publishedAt: new Date(),
        },
    };
    return nestedData;
}
