"use strict";
/**
 * member controller
 */
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::member.member", ({ strapi }) => ({
    create: async (ctx) => {
        if (typeof ctx.request.body.data.contact === "object") {
            await strapi.entityService.create("api::contact.contact", {
                data: {
                    ...ctx.request.body.contact,
                },
            });
            return;
        }
        const recievedMember = ctx.request.body.data;
        // if (!validateMember(recievedMember)) {
        //   return;
        // }
        // console.log(recievedMember);
        const structred = {
            name: recievedMember.name,
            campus: [recievedMember.campus],
            gender: recievedMember.gender,
            dateOfBirth: recievedMember.dateOfBirth,
            spouse: recievedMember.spouse,
            maritalStatus: recievedMember.maritalStatus,
            isStaff: recievedMember.isStaff,
            isPastoralMember: recievedMember.isPastoralMember,
            network: [recievedMember.network],
            discipleshipGroup: [recievedMember.discipleshipGroup],
            // Nesting for contact and studentInfo as an interpretation, not directly supported by the provided interface
            contact: {
                phone: recievedMember.phone,
                email: recievedMember.email,
            },
            studentInfo: {
                studentId: recievedMember.studentId,
                institutionName: recievedMember.institutionName,
            },
            emergencyContact: {
                name: recievedMember.emergencyContactName,
                phone: recievedMember.emergencyContactPhone,
            },
            publishedAt: new Date(),
        };
        console.log(structred);
        const member = await strapi.entityService.create("api::member.member", {
            data: structred,
        });
        ctx.response.status = 201;
        ctx.response.body = { data: member };
        return member;
    },
}));
function isValidGender(gender) {
    const validGenders = ["Male", "Female"];
    return validGenders.includes(gender);
}
function isValidMaritalStatus(maritalStatus) {
    const validMaritalStatuses = ["Married", "Single"];
    return validMaritalStatuses.includes(maritalStatus);
}
function isValidPastoralRole(pastoralRole) {
    const validPastoralRoles = [
        "Campus Pastor",
        "Network Leader",
        "Senior Pastor",
        "Executive Pastor",
        "Ministry Assistant",
    ];
    return validPastoralRoles.includes(pastoralRole);
}
function validateMember(recievedMember) {
    if (!isValidGender(recievedMember.gender)) {
        throw new Error("Invalid gender");
    }
    if (!isValidMaritalStatus(recievedMember.maritalStatus)) {
        throw new Error("Invalid marital status");
    }
    if (!isValidPastoralRole(recievedMember.pastoralRole)) {
        throw new Error("Invalid pastoral role");
    }
    // Add additional validations as needed
    return true; // All validations passed
}
