"use strict";
/**
 * mavuno-giving controller
 */
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const helpers_1 = require("../../../utils/helpers");
const campus_1 = require("../../campus/controllers/campus");
// const today = new Date();
// const midnight = new Date(today.setHours(0, 0, 0, 0));
// const tomorrow = new Date(midnight);
// tomorrow.setDate(midnight.getDate() + 1);
//
// const thirtyDaysAgo = new Date(new Date().setDate(today.getDate() - 30));
// const sixtyDaysAgo = new Date(new Date().setDate(today.getDate() - 60));
exports.default = strapi_1.factories.createCoreController("api::mavuno-giving.mavuno-giving", ({ strapi }) => {
    return {
        async org(ctx) {
            var _a;
            let entry = {};
            ctx.params;
            let type = ((_a = ctx.query) === null || _a === void 0 ? void 0 : _a.type) || "";
            const yearMonths = (0, helpers_1.getYearMonthsFromToday)();
            if (type === "pie") {
                let tithesObject = {};
                let offeringsObject = {};
                let firstFruitsObject = {};
                let chartData = {};
                for (let yidx = 0; yidx < yearMonths.length; yidx++) {
                    const month = yearMonths[yidx];
                    let hillcitytTithe = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                name: {
                                    $containsi: "HillCity",
                                },
                            },
                            type: "Tithe",
                        },
                    })
                        .then((it) => {
                        return it.reduce((acc, curr) => {
                            acc += curr.total;
                            return acc;
                        }, 0);
                    });
                    let hillcityOfferings = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                name: {
                                    $containsi: "HillCity",
                                },
                            },
                            type: "Offering",
                        },
                    })
                        .then((it) => {
                        return it.reduce((acc, curr) => {
                            acc += curr.total;
                            return acc;
                        }, 0);
                    });
                    let hillcitytFruits = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                name: {
                                    $containsi: "HillCity",
                                },
                            },
                            type: "First fruits",
                        },
                    })
                        .then((it) => {
                        return it.reduce((acc, curr) => {
                            acc += curr.total;
                            return acc;
                        }, 0);
                    });
                    let downtownTithes = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                name: {
                                    $containsi: "DownTown",
                                },
                            },
                            type: "Tithe",
                        },
                    })
                        .then((it) => {
                        return it.reduce((acc, curr) => {
                            acc += curr.total;
                            return acc;
                        }, 0);
                    });
                    let downtownOffering = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                name: {
                                    $containsi: "DownTown",
                                },
                            },
                            type: "Offering",
                        },
                    })
                        .then((it) => {
                        return it.reduce((acc, curr) => {
                            acc += curr.total;
                            return acc;
                        }, 0);
                    });
                    let downtownFruits = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                name: {
                                    $containsi: "DownTown",
                                },
                            },
                            type: "First fruits",
                        },
                    })
                        .then((it) => {
                        return it.reduce((acc, curr) => {
                            acc += curr.total;
                            return acc;
                        }, 0);
                    });
                    let masharikiTithes = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                name: {
                                    $containsi: "Mashariki",
                                },
                            },
                            type: "Tithe",
                        },
                    })
                        .then((it) => {
                        return it.reduce((acc, curr) => {
                            acc += curr.total;
                            return acc;
                        }, 0);
                    });
                    let masharikiOffering = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                name: {
                                    $containsi: "Mashariki",
                                },
                            },
                            type: "Offering",
                        },
                    })
                        .then((it) => {
                        return it.reduce((acc, curr) => {
                            acc += curr.total;
                            return acc;
                        }, 0);
                    });
                    let masharikiFruits = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                name: {
                                    $containsi: "Mashariki",
                                },
                            },
                            type: "First fruits",
                        },
                    })
                        .then((it) => {
                        return it.reduce((acc, curr) => {
                            acc += curr.total;
                            return acc;
                        }, 0);
                    });
                    let southTithes = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                name: {
                                    $containsi: "South",
                                },
                            },
                            type: "Tithe",
                        },
                    })
                        .then((it) => {
                        return it.reduce((acc, curr) => {
                            acc += curr.total;
                            return acc;
                        }, 0);
                    });
                    let southOffering = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                name: {
                                    $containsi: "South",
                                },
                            },
                            type: "Offering",
                        },
                    })
                        .then((it) => {
                        return it.reduce((acc, curr) => {
                            acc += curr.total;
                            return acc;
                        }, 0);
                    });
                    let southFruits = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                name: {
                                    $containsi: "South",
                                },
                            },
                            type: "First fruits",
                        },
                    })
                        .then((it) => {
                        return it.reduce((acc, curr) => {
                            acc += curr.total;
                            return acc;
                        }, 0);
                    });
                    let lifewayTithes = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                name: {
                                    $containsi: "Lifeway",
                                },
                            },
                            type: "Tithe",
                        },
                    })
                        .then((it) => {
                        return it.reduce((acc, curr) => {
                            acc += curr.total;
                            return acc;
                        }, 0);
                    });
                    let lifewayOffering = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                name: {
                                    $containsi: "Lifeway",
                                },
                            },
                            type: "Offering",
                        },
                    })
                        .then((it) => {
                        return it.reduce((acc, curr) => {
                            acc += curr.total;
                            return acc;
                        }, 0);
                    });
                    let lifewayFruits = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                name: {
                                    $containsi: "Lifeway",
                                },
                            },
                            type: "First fruits",
                        },
                    })
                        .then((it) => {
                        return it.reduce((acc, curr) => {
                            acc += curr.total;
                            return acc;
                        }, 0);
                    });
                    let tithes = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            type: "Tithe",
                        },
                    })
                        .then((it) => it.reduce((acc, curr) => {
                        acc += curr.total;
                        return acc;
                    }, 0));
                    let firstFruits = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            type: "First fruits",
                        },
                    })
                        .then((it) => it.reduce((acc, curr) => {
                        acc += curr.total;
                        return acc;
                    }, 0));
                    let offerings = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            type: "Offering",
                        },
                    })
                        .then((it) => it.reduce((acc, curr) => {
                        acc += curr.total;
                        return acc;
                    }, 0));
                    let name = (0, helpers_1.getCurrentMonthShortName)() == month.name
                        ? "thisMonth"
                        : month.name == (0, helpers_1.getLastMonthShortName)()
                            ? "lastMonth"
                            : month.name.toLowerCase();
                    let longname = (0, helpers_1.getCurrentMonthShortName)() == month.name
                        ? "This Month"
                        : month.name == (0, helpers_1.getLastMonthShortName)()
                            ? "Last Month"
                            : (0, helpers_1.shortNameToLongName)(month.name);
                    chartData[name] = [
                        {
                            id: longname,
                            name: "Tithe",
                            value: tithes,
                            bg: "#F5D870",
                        },
                        {
                            id: longname,
                            name: "First fruits",
                            value: firstFruits,
                            bg: "#6C42BD",
                        },
                        {
                            id: longname,
                            name: "Offering",
                            value: offerings,
                            bg: "#F27040",
                        },
                    ];
                    firstFruitsObject[name] = [
                        {
                            id: longname,
                            name: "Hillcity",
                            value: hillcitytFruits,
                            bg: "#6C42BD",
                        },
                        {
                            id: longname,
                            name: "Downtown",
                            value: downtownFruits,
                            bg: "#F88507",
                        },
                        {
                            id: longname,
                            name: "Mashariki",
                            value: masharikiFruits,
                            bg: "#0EB7F1",
                        },
                        {
                            id: longname,
                            name: "South",
                            value: southFruits,
                            bg: "#68BE41",
                        },
                        {
                            id: longname,
                            name: "Lifeway",
                            value: lifewayFruits,
                            bg: "#C13E8B",
                        },
                    ];
                    offeringsObject[name] = [
                        {
                            id: longname,
                            name: "Hillcity",
                            value: hillcityOfferings,
                            bg: "#6C42BD",
                        },
                        {
                            id: longname,
                            name: "Downtown",
                            value: downtownOffering,
                            bg: "#F88507",
                        },
                        {
                            id: longname,
                            name: "Mashariki",
                            value: masharikiOffering,
                            bg: "#0EB7F1",
                        },
                        {
                            id: longname,
                            name: "South",
                            value: southOffering,
                            bg: "#68BE41",
                        },
                        {
                            id: longname,
                            name: "Lifeway",
                            value: lifewayOffering,
                            bg: "#C13E8B",
                        },
                    ];
                    tithesObject[name] = [
                        {
                            id: longname,
                            name: "Hillcity",
                            value: hillcitytTithe,
                            bg: "#6C42BD",
                        },
                        {
                            id: longname,
                            name: "Downtown",
                            value: downtownTithes,
                            bg: "#F88507",
                        },
                        {
                            id: longname,
                            name: "Mashariki",
                            value: masharikiTithes,
                            bg: "#0EB7F1",
                        },
                        {
                            id: longname,
                            name: "South",
                            value: southTithes,
                            bg: "#68BE41",
                        },
                        {
                            id: longname,
                            name: "Lifeway",
                            value: lifewayTithes,
                            bg: "#C13E8B",
                        },
                    ];
                }
                ctx.body = {
                    data: {
                        organistion: chartData,
                        firstFruits: firstFruitsObject,
                        offerings: offeringsObject,
                        tithes: tithesObject,
                    },
                    meta: {},
                };
                return;
            }
            const monthNames = yearMonths.map((it) => it.startDate.toLocaleString("en-US", { month: "short" }));
            let networks = await strapi.entityService.findMany("api::network.network");
            let thisMonthgiving = await strapi.entityService.findMany("api::mavuno-giving.mavuno-giving", {
                filters: {
                    date: {
                        $gt: (0, helpers_1.getStartOfMonth)(),
                    },
                },
            });
            let lastMonthgiving = await strapi.entityService.findMany("api::mavuno-giving.mavuno-giving", {
                filters: {
                    date: {
                        $lte: (0, helpers_1.getStartOfMonth)(),
                        $gte: (0, helpers_1.getStartOfPreviousMonth)(),
                    },
                },
            });
            let thisWeekgiving = await strapi.entityService.findMany("api::mavuno-giving.mavuno-giving", {
                filters: {
                    date: {
                        $gt: (0, helpers_1.getStartOfWeek)(),
                    },
                },
            });
            let todaysGiving = await strapi.entityService.findMany("api::mavuno-giving.mavuno-giving", {
                filters: {
                    date: {
                        $gt: (0, helpers_1.getMidnightToday)(),
                    },
                },
            });
            entry["organistion"] = {};
            entry["organistion"]["thisMonth"] = processsGiving(thisMonthgiving);
            entry["organistion"]["lastMonth"] = processsGiving(lastMonthgiving);
            entry["organistion"]["thisWeek"] = processsGiving(thisWeekgiving);
            entry["organistion"]["today"] = processsGiving(todaysGiving);
            // summaries for each network
            let newtorkSummaries = [];
            for (let index = 0; index < networks.length; index++) {
                const element = networks[index];
                let monthly = await findNetworkSummary(element.id, (0, helpers_1.getStartOfMonth)(), strapi);
                let lastMonth = await findNetworkSummary(element.id, (0, helpers_1.getStartOfPreviousMonth)(), strapi);
                let weekly = await findNetworkSummary(element.id, (0, helpers_1.getStartOfWeek)(), strapi);
                let daily = await findNetworkSummary(element.id, (0, helpers_1.getMidnightToday)(), strapi);
                let yearsum = [];
                for (let yidx = 0; yidx < yearMonths.length; yidx++) {
                    const month = yearMonths[yidx];
                    let value = await findNetworkSummary(element.id, month.startDate, strapi, true, month.endDate);
                    yearsum.push({ month: monthNames[yidx], ...value });
                }
                newtorkSummaries.push({
                    network: (0, campus_1.omitFieldsRecursively)(element),
                    day: daily,
                    week: weekly,
                    month: monthly,
                    lastMonth,
                    year: yearsum.reverse(),
                });
            }
            entry["networks"] = newtorkSummaries;
            let recent = await strapi.entityService.findMany("api::mavuno-giving.mavuno-giving", {
                filters: {},
                sort: "date:desc",
                populate: "*",
                limit: 8,
            });
            for (let index = 0; index < recent.length; index++) {
                const expense = recent[index];
                recent[index].campus = await strapi.entityService.findOne("api::campus.campus", expense.campus.id, {
                    populate: "network",
                });
            }
            recent = (0, campus_1.omitFieldsRecursively)(recent);
            entry["recent"] = recent;
            ctx.body = { data: entry, meta: {} };
        },
        async network(ctx) {
            var _a;
            let entry = {};
            let id = ctx.params.id;
            let type = ((_a = ctx.query) === null || _a === void 0 ? void 0 : _a.type) || "";
            const yearMonths = (0, helpers_1.getYearMonthsFromToday)();
            let network = await strapi.entityService.findOne("api::network.network", id);
            if (!network) {
                ctx.body = { data: [], meta: {} };
                return;
            }
            if (type === "graph") {
                let chartData = [];
                for (let yidx = 0; yidx < yearMonths.length; yidx++) {
                    const month = yearMonths[yidx];
                    let chartItem = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                id: id,
                            },
                        },
                    })
                        .then((it) => it.reduce((acc, curr) => {
                        acc += curr.total;
                        return acc;
                    }, 0));
                    chartData.push({
                        month: month.name,
                        totals: chartItem,
                    });
                }
                ctx.body = { data: chartData.reverse(), meta: {} };
                return;
            }
            if (type === "pie") {
                let chartData = {};
                for (let yidx = 0; yidx < yearMonths.length; yidx++) {
                    const month = yearMonths[yidx];
                    let tithes = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                id: {
                                    $eq: network.id,
                                },
                            },
                            type: "Tithe",
                        },
                    })
                        .then((it) => it.reduce((acc, curr) => {
                        acc += curr.total;
                        return acc;
                    }, 0));
                    let firstFruits = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                id: {
                                    $eq: network.id,
                                },
                            },
                            type: "First fruits",
                        },
                    })
                        .then((it) => it.reduce((acc, curr) => {
                        acc += curr.total;
                        return acc;
                    }, 0));
                    let offerings = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            network: {
                                id: {
                                    $eq: network.id,
                                },
                            },
                            type: "Offering",
                        },
                    })
                        .then((it) => it.reduce((acc, curr) => {
                        acc += curr.total;
                        return acc;
                    }, 0));
                    let name = (0, helpers_1.getCurrentMonthShortName)() == month.name
                        ? "thisMonth"
                        : month.name == (0, helpers_1.getLastMonthShortName)()
                            ? "lastMonth"
                            : month.name.toLowerCase();
                    let longname = (0, helpers_1.getCurrentMonthShortName)() == month.name
                        ? "This Month"
                        : month.name == (0, helpers_1.getLastMonthShortName)()
                            ? "Last Month"
                            : (0, helpers_1.shortNameToLongName)(month.name);
                    chartData[name] = [
                        {
                            name: "Tithe",
                            value: tithes,
                            bg: "#F5D870",
                        },
                        {
                            name: "First fruits",
                            value: firstFruits,
                            bg: "#6C42BD",
                        },
                        {
                            name: "Offering",
                            value: offerings,
                            bg: "#F5D870",
                        },
                    ];
                }
                ctx.body = { data: chartData, meta: {} };
                return;
            }
            let monthly = await findNetworkSummary(id, (0, helpers_1.getStartOfMonth)(), strapi);
            let weekly = await findNetworkSummary(id, (0, helpers_1.getStartOfWeek)(), strapi);
            let daily = await findNetworkSummary(id, (0, helpers_1.getMidnightToday)(), strapi);
            let yearsum = [];
            for (let yidx = 0; yidx < yearMonths.length; yidx++) {
                const month = yearMonths[yidx];
                let value = await findNetworkSummary(id, month.startDate, strapi, true, month.endDate);
                yearsum.push({ month: month.name, ...value });
            }
            let campusData = await getCampusCumilate(network.id, strapi);
            let recent = await strapi.entityService.findMany("api::mavuno-giving.mavuno-giving", {
                filters: {
                    network: {
                        id: {
                            $eq: id,
                        },
                    },
                },
                sort: "date:desc",
                populate: "*",
                limit: 8,
            });
            for (let index = 0; index < recent.length; index++) {
                const expense = recent[index];
                recent[index].campus = await strapi.entityService.findOne("api::campus.campus", expense.campus.id, {
                    populate: "network",
                });
            }
            recent = (0, campus_1.omitFieldsRecursively)(recent);
            entry = {
                network: { ...network },
                year: yearsum.reverse(),
                month: monthly,
                week: weekly,
                day: daily,
                recent,
                campuses: campusData,
            };
            ctx.body = { data: entry, meta: {} };
        },
        async campus(ctx) {
            var _a;
            let entry = {};
            let campusId = ctx.params.id;
            let type = ((_a = ctx.query) === null || _a === void 0 ? void 0 : _a.type) || "";
            let givings = [];
            const yearMonths = (0, helpers_1.getYearMonthsFromToday)();
            const monthNames = yearMonths.map((it) => it.startDate.toLocaleString("en-US", { month: "long" }));
            let theCampus = await strapi.entityService.findOne("api::campus.campus", campusId);
            if (!theCampus) {
                ctx.body = { data: [], meta: {} };
                return;
            }
            if (type === "graph") {
                let chartData = [];
                for (let yidx = 0; yidx < yearMonths.length; yidx++) {
                    const month = yearMonths[yidx];
                    let chartItem = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            campus: {
                                id: {
                                    $eq: campusId,
                                },
                            },
                        },
                    })
                        .then((it) => it.reduce((acc, curr) => {
                        acc += curr.total;
                        return acc;
                    }, 0));
                    chartData.push({
                        month: month.name,
                        totals: chartItem,
                    });
                }
                ctx.body = { data: chartData, meta: {} };
                return;
            }
            if (type === "pie") {
                let chartData = {};
                for (let yidx = 0; yidx < yearMonths.length; yidx++) {
                    const month = yearMonths[yidx];
                    let tithes = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            campus: {
                                id: {
                                    $eq: theCampus.id,
                                },
                            },
                            type: "Tithe",
                        },
                    })
                        .then((it) => it.reduce((acc, curr) => {
                        acc += curr.total;
                        return acc;
                    }, 0));
                    let firstFruits = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            campus: {
                                id: {
                                    $eq: theCampus.id,
                                },
                            },
                            type: "First fruits",
                        },
                    })
                        .then((it) => it.reduce((acc, curr) => {
                        acc += curr.total;
                        return acc;
                    }, 0));
                    let offerings = await strapi.entityService
                        .findMany("api::mavuno-giving.mavuno-giving", {
                        filters: {
                            date: {
                                $gte: month.startDate,
                                $lte: month.endDate,
                            },
                            campus: {
                                id: {
                                    $eq: theCampus.id,
                                },
                            },
                            type: "Offering",
                        },
                    })
                        .then((it) => it.reduce((acc, curr) => {
                        acc += curr.total;
                        return acc;
                    }, 0));
                    let name = (0, helpers_1.getCurrentMonthShortName)() == month.name
                        ? "thisMonth"
                        : month.name == (0, helpers_1.getLastMonthShortName)()
                            ? "lastMonth"
                            : month.name.toLowerCase();
                    let longname = (0, helpers_1.getCurrentMonthShortName)() == month.name
                        ? "This Month"
                        : month.name == (0, helpers_1.getLastMonthShortName)()
                            ? "Last Month"
                            : (0, helpers_1.shortNameToLongName)(month.name);
                    chartData[name] = [
                        {
                            name: "Tithe",
                            value: tithes,
                            bg: "#F5D870",
                        },
                        {
                            name: "First fruits",
                            value: firstFruits,
                            bg: "#6C42BD",
                        },
                        {
                            name: "Offering",
                            value: offerings,
                            bg: "#F5D870",
                        },
                    ];
                }
                ctx.body = { data: chartData, meta: {} };
                return;
            }
            let day = await findCampusSummary((0, helpers_1.getMidnightToday)(), campusId);
            let week = await findCampusSummary((0, helpers_1.getStartOfWeek)(), campusId);
            let month = await findCampusSummary((0, helpers_1.getStartOfMonth)(), campusId);
            for (let yidx = 0; yidx < yearMonths.length; yidx++) {
                const month = yearMonths[yidx];
                let giving = await strapi.entityService.findMany("api::mavuno-giving.mavuno-giving", {
                    filters: {
                        campus: {
                            id: {
                                $eq: campusId,
                            },
                        },
                        date: {
                            $lte: month.endDate,
                            $gte: month.startDate,
                        },
                    },
                });
                givings.push({ month: monthNames[yidx], ...processsGiving(giving) });
            }
            let recent = await strapi.entityService.findMany("api::mavuno-giving.mavuno-giving", {
                filters: {
                    campus: {
                        id: {
                            $eq: campusId,
                        },
                    },
                },
                sort: "date:desc",
                populate: "*",
                limit: 8,
            });
            for (let index = 0; index < recent.length; index++) {
                const expense = recent[index];
                recent[index].campus = await strapi.entityService.findOne("api::campus.campus", expense.campus.id, {
                    populate: "network",
                });
            }
            recent = (0, campus_1.omitFieldsRecursively)(recent);
            entry = {
                name: theCampus.name,
                day,
                week,
                month,
                year: givings.reverse(),
                recent,
            };
            ctx.body = { data: entry, meta: {} };
        },
    };
});
async function getCampusCumilate(networkId, strapi) {
    let campusIds = await strapi.entityService.findMany("api::campus.campus", {
        filters: {
            network: {
                id: {
                    $eq: networkId,
                },
            },
        },
    });
    const yearMonths = (0, helpers_1.getYearMonthsFromToday)();
    const monthNames = yearMonths.map((it) => it.startDate.toLocaleString("en-US", { month: "long" }));
    let summary = [];
    for (let index = 0; index < campusIds.length; index++) {
        const campus = campusIds[index];
        let givings = [];
        for (let yidx = 0; yidx < yearMonths.length; yidx++) {
            const month = yearMonths[yidx];
            let giving = await strapi.entityService.findMany("api::mavuno-giving.mavuno-giving", {
                filters: {
                    campus: {
                        id: {
                            $eq: campus.id,
                        },
                    },
                    date: {
                        $lte: month.endDate,
                        $gte: month.startDate,
                    },
                },
            });
            givings.push({ month: monthNames[yidx], ...processsGiving(giving) });
        }
        givings.reverse();
        summary.push({ name: campus.name, givings });
    }
    return summary;
}
async function findCampusSummary(startDate, id) {
    let givings = await strapi.entityService.findMany("api::mavuno-giving.mavuno-giving", {
        filters: {
            $or: [
                {
                    date: {
                        $eq: startDate,
                    },
                },
                {
                    date: {
                        $gt: startDate,
                    },
                },
            ],
            campus: {
                id: {
                    $eq: id,
                },
            },
        },
    });
    return processsGiving(givings);
}
async function findNetworkSummary(networkId, startDate, strapi, year = false, endDate = null) {
    let campusIds = await strapi.entityService
        .findMany("api::campus.campus", {
        filters: {
            network: {
                id: {
                    $eq: networkId,
                },
            },
        },
    })
        .then((it) => it.map((campus) => campus.id));
    let giving = year && endDate
        ? await strapi.entityService.findMany("api::mavuno-giving.mavuno-giving", {
            filters: {
                date: {
                    $lte: endDate,
                    $gte: startDate,
                },
                campus: {
                    id: {
                        $in: campusIds,
                    },
                },
            },
        })
        : await strapi.entityService.findMany("api::mavuno-giving.mavuno-giving", {
            filters: {
                $or: [
                    {
                        date: {
                            $eq: startDate,
                        },
                    },
                    {
                        date: {
                            $gt: startDate,
                        },
                    },
                ],
                campus: {
                    id: {
                        $in: campusIds,
                    },
                },
            },
        });
    return processsGiving(giving);
}
function processsGiving(giving) {
    let grouped = (0, helpers_1.groupBy)(giving, "type");
    let summed = Object.keys(grouped).map((key) => {
        let obj = {};
        obj[key] = (0, helpers_1.sumByKey)(grouped[key], "total");
        return obj;
    });
    let obj = {
        Offering: 0,
        "First fruits": 0,
        Tithe: 0,
        total: 0,
    };
    let summary = { ...obj, ...(0, helpers_1.arrayToObject)(summed) };
    let transformed = (0, helpers_1.normalizeKeys)({
        ...summary,
        total: (0, helpers_1.sumObjectValues)(summary),
    });
    return transformed;
}
