"use strict";
/**
 * expense controller
 */
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
const helpers_1 = require("../../../utils/helpers");
const campus_1 = require("../../campus/controllers/campus");
const network_1 = require("../../network/controllers/network");
exports.default = strapi_1.factories.createCoreController("api::expense.expense", ({ strapi }) => ({
    async org(ctx) {
        let type = ctx.query.type || "";
        let theYear = (0, helpers_1.getMonthsForYearFromDate)(new Date());
        if (type === "pie") {
            let chartData = {};
            for (let yidx = 0; yidx < theYear.length; yidx++) {
                const month = theYear[yidx];
                let hillcity = await strapi.entityService
                    .findMany("api::expense.expense", {
                    filters: {
                        date: {
                            $gte: month.startDate,
                            $lte: month.endDate,
                        },
                        network: {
                            name: {
                                $containsi: "HillCity",
                            },
                        },
                    },
                })
                    .then((it) => {
                    return it.reduce((acc, curr) => {
                        acc += curr.amount;
                        return acc;
                    }, 0);
                });
                let downtown = await strapi.entityService
                    .findMany("api::expense.expense", {
                    filters: {
                        date: {
                            $gte: month.startDate,
                            $lte: month.endDate,
                        },
                        network: {
                            name: {
                                $containsi: "DownTown",
                            },
                        },
                    },
                })
                    .then((it) => {
                    return it.reduce((acc, curr) => {
                        acc += curr.amount;
                        return acc;
                    }, 0);
                });
                let mashariki = await strapi.entityService
                    .findMany("api::expense.expense", {
                    filters: {
                        date: {
                            $gte: month.startDate,
                            $lte: month.endDate,
                        },
                        network: {
                            name: {
                                $containsi: "Mashariki",
                            },
                        },
                    },
                })
                    .then((it) => {
                    return it.reduce((acc, curr) => {
                        acc += curr.amount;
                        return acc;
                    }, 0);
                });
                let south = await strapi.entityService
                    .findMany("api::expense.expense", {
                    filters: {
                        date: {
                            $gte: month.startDate,
                            $lte: month.endDate,
                        },
                        network: {
                            name: {
                                $containsi: "South",
                            },
                        },
                    },
                })
                    .then((it) => {
                    return it.reduce((acc, curr) => {
                        acc += curr.amount;
                        return acc;
                    }, 0);
                });
                let lifeway = await strapi.entityService
                    .findMany("api::expense.expense", {
                    filters: {
                        date: {
                            $gte: month.startDate,
                            $lte: month.endDate,
                        },
                        network: {
                            name: {
                                $containsi: "Lifeway",
                            },
                        },
                    },
                })
                    .then((it) => {
                    return it.reduce((acc, curr) => {
                        acc += curr.amount;
                        return acc;
                    }, 0);
                });
                let name = (0, helpers_1.getCurrentMonthShortName)() == month.name
                    ? "thisMonth"
                    : month.name == (0, helpers_1.getLastMonthShortName)()
                        ? "lastMonth"
                        : month.name.toLowerCase();
                let longname = (0, helpers_1.getCurrentMonthShortName)() == month.name
                    ? "This Month"
                    : month.name == (0, helpers_1.getLastMonthShortName)()
                        ? "Last Month"
                        : (0, helpers_1.shortNameToLongName)(month.name);
                chartData[name] = [
                    {
                        id: longname,
                        name: "Hillcity",
                        value: hillcity,
                        bg: "#6C42BD",
                    },
                    {
                        id: longname,
                        name: "Downtown",
                        value: downtown,
                        bg: "#F88507",
                    },
                    {
                        id: longname,
                        name: "Mashariki",
                        value: mashariki,
                        bg: "#0EB7F1",
                    },
                    {
                        id: longname,
                        name: "South",
                        value: south,
                        bg: "#68BE41",
                    },
                    {
                        id: longname,
                        name: "Lifeway",
                        value: lifeway,
                        bg: "#C13E8B",
                    },
                ];
            }
            ctx.body = { data: chartData, meta: {} };
            return;
        }
        let orgExpenseThisMonth = await strapi.entityService
            .findMany("api::expense.expense", {
            filters: {
                date: {
                    $gte: (0, helpers_1.getStartOfMonth)(),
                },
            },
        })
            .then((it) => it.reduce((acc, it) => acc + it.amount, 0));
        let orgExpenseLastMonth = await strapi.entityService
            .findMany("api::expense.expense", {
            filters: {
                date: {
                    $lte: (0, helpers_1.getStartOfMonth)(),
                    $gte: (0, helpers_1.getStartOfPreviousMonth)(),
                },
            },
        })
            .then((it) => it.reduce((acc, it) => acc + it.amount, 0));
        let orgExpenseThisWeek = await strapi.entityService
            .findMany("api::expense.expense", {
            filters: {
                date: {
                    $gt: (0, helpers_1.getStartOfWeek)(),
                },
            },
        })
            .then((it) => it.reduce((acc, it) => acc + it.amount, 0));
        let orgExpenseToday = await strapi.entityService
            .findMany("api::expense.expense", {
            filters: {
                date: {
                    $gt: (0, helpers_1.getMidnightToday)(),
                },
            },
        })
            .then((it) => it.reduce((acc, it) => acc + it.amount, 0));
        let orgExpenseTrend = (0, network_1.getTrend)(orgExpenseThisMonth, orgExpenseLastMonth);
        let orgAllocationsThisMonth = await strapi.entityService
            .findMany("api::money-allocation.money-allocation", {
            filters: {
                date: {
                    $gte: (0, helpers_1.getStartOfMonth)(),
                },
            },
        })
            .then((it) => it.reduce((acc, it) => acc + it.amount, 0));
        let orgAllocationsLastMonth = await strapi.entityService
            .findMany("api::money-allocation.money-allocation", {
            filters: {
                date: {
                    $lte: (0, helpers_1.getStartOfMonth)(),
                    $gte: (0, helpers_1.getStartOfPreviousMonth)(),
                },
            },
        })
            .then((it) => it.reduce((acc, it) => acc + it.amount, 0));
        let orgAllocationsTrend = (0, network_1.getTrend)(orgAllocationsThisMonth, orgAllocationsLastMonth);
        let orgAllocationsThisWeek = await strapi.entityService
            .findMany("api::money-allocation.money-allocation", {
            filters: {
                date: {
                    $gt: (0, helpers_1.getStartOfWeek)(),
                },
            },
        })
            .then((it) => it.reduce((acc, it) => acc + it.amount, 0));
        let orgAllocationsToday = await strapi.entityService
            .findMany("api::money-allocation.money-allocation", {
            filters: {
                date: {
                    $gt: (0, helpers_1.getMidnightToday)(),
                },
            },
        })
            .then((it) => it.reduce((acc, it) => acc + it.amount, 0));
        let allocations = {
            today: orgAllocationsToday,
            thisWeek: orgAllocationsThisWeek,
            thisMonth: orgAllocationsThisMonth,
            lastMonth: orgAllocationsLastMonth,
            trend: orgAllocationsTrend,
        };
        let expenses = {
            today: orgExpenseToday,
            thisWeek: orgExpenseThisWeek,
            thisMonth: orgExpenseThisMonth,
            lastMonth: orgExpenseLastMonth,
            trend: orgExpenseTrend,
        };
        let lastMonthBalance = orgAllocationsLastMonth - orgExpenseLastMonth;
        let thisMonthBalance = orgAllocationsThisMonth - orgExpenseThisMonth;
        let balanceTrend = (0, network_1.getTrend)(thisMonthBalance, lastMonthBalance);
        let balance = {
            remainingAmount: orgAllocationsThisMonth - orgExpenseThisMonth,
            remainingPercentage: ((orgAllocationsThisMonth - orgExpenseThisMonth) /
                orgAllocationsThisMonth) *
                100,
            balanceTrend,
            lastMonthBalance,
            thisMonthBalance,
        };
        let acc = [];
        let networks = await strapi.entityService.findMany("api::network.network");
        for (let nidx = 0; nidx < networks.length; nidx++) {
            let network = networks[nidx];
            let ctx = {
                params: {
                    id: network.id,
                },
            };
            let summary = await this.network(ctx);
            acc.push({ network: network, ...summary });
        }
        let inOneYear = [];
        for (let ntidx = 0; ntidx < networks.length; ntidx++) {
            const network = networks[ntidx];
            let campuses = await strapi.entityService.findMany("api::campus.campus", {
                filters: {
                    network: {
                        id: network.id,
                    },
                },
            });
            let singleNetwork = [];
            // get network expenses for diffent months
            for (let yidx = 0; yidx < theYear.length; yidx++) {
                const month = theYear[yidx];
                // network expenses for in the network at monthly interval
                let results = await strapi.entityService.findMany("api::expense.expense", {
                    filters: {
                        date: {
                            $gte: month.startDate,
                            $lte: month.endDate,
                        },
                        campus: {
                            id: {
                                $in: campuses.map((it) => it.id),
                            },
                        },
                    },
                    populate: "*",
                });
                let expense = results.reduce((acc, curr) => curr.amount + acc, 0);
                singleNetwork.push({
                    month: month.name,
                    expense,
                });
            }
            inOneYear.push({ network, expenses: singleNetwork });
        }
        let recent = await strapi.entityService.findMany("api::expense.expense", {
            filters: {},
            sort: "date:desc",
            populate: "*",
            limit: 8,
        });
        for (let index = 0; index < recent.length; index++) {
            const expense = recent[index];
            recent[index].campus = await strapi.entityService.findOne("api::campus.campus", expense.campus.id, {
                populate: "network",
            });
        }
        recent = (0, campus_1.omitFieldsRecursively)(recent);
        ctx.body = {
            data: {
                organisation: {
                    allocations,
                    expenses,
                    balance,
                },
                networks: inOneYear,
                entries: acc,
                recent,
            },
            meta: {},
        };
    },
    async network(ctx) {
        var _a;
        let theYear = (0, helpers_1.getMonthsForYearFromDate)(new Date());
        let netId = ctx.params.id;
        let type = ((_a = ctx === null || ctx === void 0 ? void 0 : ctx.query) === null || _a === void 0 ? void 0 : _a.type) || "";
        let network = await strapi.entityService.findOne("api::network.network", netId, {
            populate: "*",
        });
        if (!network) {
            ctx.body = { data: [], meta: {} };
        }
        if (type === "graph") {
            let chartData = [];
            for (let yidx = 0; yidx < theYear.length; yidx++) {
                const month = theYear[yidx];
                let results = await strapi.entityService.findMany("api::expense.expense", {
                    filters: {
                        date: {
                            $gte: month.startDate,
                            $lte: month.endDate,
                        },
                        network: {
                            id: {
                                $eq: network.id,
                            },
                        },
                    },
                    populate: "*",
                });
                let expense = results.reduce((acc, curr) => curr.amount + acc, 0);
                chartData.push({
                    month: month.name,
                    total: expense,
                });
            }
            ctx.body = {
                data: chartData.reverse(),
                meta: {},
            };
            return;
        }
        let orgExpenseThisMonth = await strapi.entityService
            .findMany("api::expense.expense", {
            filters: {
                date: {
                    $gte: (0, helpers_1.getStartOfMonth)(),
                },
                network: {
                    id: {
                        $eq: network.id,
                    },
                },
            },
        })
            .then((it) => it.reduce((acc, it) => acc + it.amount, 0));
        let orgExpenseLastMonth = await strapi.entityService
            .findMany("api::expense.expense", {
            filters: {
                date: {
                    $lte: (0, helpers_1.getStartOfMonth)(),
                    $gte: (0, helpers_1.getStartOfPreviousMonth)(),
                },
                network: {
                    id: {
                        $eq: network.id,
                    },
                },
            },
        })
            .then((it) => it.reduce((acc, it) => acc + it.amount, 0));
        let orgExpenseThisWeek = await strapi.entityService
            .findMany("api::expense.expense", {
            filters: {
                date: {
                    $gt: (0, helpers_1.getStartOfWeek)(),
                },
                network: {
                    id: {
                        $eq: network.id,
                    },
                },
            },
        })
            .then((it) => it.reduce((acc, it) => acc + it.amount, 0));
        let orgExpenseToday = await strapi.entityService
            .findMany("api::expense.expense", {
            filters: {
                date: {
                    $gt: (0, helpers_1.getMidnightToday)(),
                },
                network: {
                    id: {
                        $eq: network.id,
                    },
                },
            },
        })
            .then((it) => it.reduce((acc, it) => acc + it.amount, 0));
        let orgExpenseTrend = (0, network_1.getTrend)(orgExpenseThisMonth, orgExpenseLastMonth);
        let orgAllocationsThisMonth = await strapi.entityService
            .findMany("api::money-allocation.money-allocation", {
            filters: {
                date: {
                    $gte: (0, helpers_1.getStartOfMonth)(),
                },
                network: {
                    id: {
                        $eq: network.id,
                    },
                },
            },
        })
            .then((it) => it.reduce((acc, it) => acc + it.amount, 0));
        let orgAllocationsLastMonth = await strapi.entityService
            .findMany("api::money-allocation.money-allocation", {
            filters: {
                date: {
                    $lte: (0, helpers_1.getStartOfMonth)(),
                    $gte: (0, helpers_1.getStartOfPreviousMonth)(),
                },
                network: {
                    id: {
                        $eq: network.id,
                    },
                },
            },
        })
            .then((it) => it.reduce((acc, it) => acc + it.amount, 0));
        let orgAllocationsTrend = (0, network_1.getTrend)(orgAllocationsThisMonth, orgAllocationsLastMonth);
        let orgAllocationsThisWeek = await strapi.entityService
            .findMany("api::money-allocation.money-allocation", {
            filters: {
                date: {
                    $gt: (0, helpers_1.getStartOfWeek)(),
                },
                network: {
                    id: {
                        $eq: network.id,
                    },
                },
            },
        })
            .then((it) => it.reduce((acc, it) => acc + it.amount, 0));
        let orgAllocationsToday = await strapi.entityService
            .findMany("api::money-allocation.money-allocation", {
            filters: {
                date: {
                    $gt: (0, helpers_1.getMidnightToday)(),
                },
                network: {
                    id: {
                        $eq: network.id,
                    },
                },
            },
        })
            .then((it) => it.reduce((acc, it) => acc + it.amount, 0));
        let allocations = {
            today: orgAllocationsToday,
            thisWeek: orgAllocationsThisWeek,
            thisMonth: orgAllocationsThisMonth,
            lastMonth: orgAllocationsLastMonth,
            trend: orgAllocationsTrend,
        };
        let expenses = {
            today: orgExpenseToday,
            thisWeek: orgExpenseThisWeek,
            thisMonth: orgExpenseThisMonth,
            lastMonth: orgExpenseLastMonth,
            trend: orgExpenseTrend,
        };
        let lastMonthBalance = orgAllocationsLastMonth - orgExpenseLastMonth;
        let thisMonthBalance = orgAllocationsThisMonth - orgExpenseThisMonth;
        let balanceTrend = (0, network_1.getTrend)(thisMonthBalance, lastMonthBalance);
        let balance = {
            remainingAmount: orgAllocationsThisMonth - orgExpenseThisMonth,
            remainingPercentage: ((orgAllocationsThisMonth - orgExpenseThisMonth) /
                orgAllocationsThisMonth) *
                100,
            balanceTrend,
            lastMonthBalance,
            thisMonthBalance,
        };
        let campuses = network.campuses;
        let inOneYear = [];
        // loop through all campuses in the network
        for (let cidx = 0; cidx < campuses.length; cidx++) {
            let campus = campuses[cidx];
            let singleNetwork = [];
            for (let yidx = 0; yidx < theYear.length; yidx++) {
                const month = theYear[yidx];
                let results = await strapi.entityService.findMany("api::expense.expense", {
                    filters: {
                        date: {
                            $gte: month.startDate,
                            $lte: month.endDate,
                        },
                        campus: {
                            id: {
                                $eq: campus.id,
                            },
                        },
                    },
                    populate: "*",
                });
                let expense = results.reduce((acc, curr) => curr.amount + acc, 0);
                singleNetwork.push({
                    month: month.name,
                    expense,
                });
            }
            inOneYear.push({ name: campus.name, expenses: singleNetwork });
        }
        let thisWeek = await findNetworkExpenses(network, strapi, (0, helpers_1.getStartOfWeek)());
        let thisMonth = await findNetworkExpenses(network, strapi, (0, helpers_1.getStartOfMonth)());
        let lastMonth = await findNetworkExpenses(network, strapi, (0, helpers_1.getStartOfPreviousMonth)());
        let today = await findNetworkExpenses(network, strapi, (0, helpers_1.getMidnightToday)());
        let res = {
            organisation: {
                allocations,
                expenses,
                balance,
            },
            network: network,
            today,
            thisWeek,
            thisMonth,
            lastMonth,
        };
        let recent = await strapi.entityService.findMany("api::expense.expense", {
            filters: {
                campus: {
                    id: {
                        $in: campuses.map((it) => it.id),
                    },
                },
            },
            sort: "date:desc",
            populate: "*",
            limit: 8,
        });
        for (let index = 0; index < recent.length; index++) {
            const expense = recent[index];
            recent[index].campus = await strapi.entityService.findOne("api::campus.campus", expense.campus.id, {
                populate: "network",
            });
        }
        recent = (0, campus_1.omitFieldsRecursively)(recent);
        res = (0, campus_1.omitFieldsRecursively)(res);
        ctx.body = {
            data: {
                ...res,
                campuses: inOneYear,
                recent,
            },
            meta: {},
        };
        return ctx.body.data;
    },
    async campus(ctx) {
        var _a, _b;
        let campusId = ctx.params.id;
        let type = ((_a = ctx === null || ctx === void 0 ? void 0 : ctx.query) === null || _a === void 0 ? void 0 : _a.type) || "";
        let entries = ((_b = ctx === null || ctx === void 0 ? void 0 : ctx.query) === null || _b === void 0 ? void 0 : _b.entries) || "";
        if ((0, helpers_1.isValidInteger)(campusId) === false) {
            return;
        }
        let campus = await strapi.entityService.findOne("api::campus.campus", campusId);
        let theYear = (0, helpers_1.getMonthsForYearFromDate)(new Date());
        if (!campus) {
            ctx.body = { data: [], meta: {} };
            return;
        }
        let id = campus.id;
        let month = theYear[0];
        let previousMonth = theYear[1];
        console.log("this month", month, "previous month", previousMonth);
        let currentGiving = await strapi.entityService
            .findMany("api::mavuno-giving.mavuno-giving", {
            filters: {
                date: {
                    $gte: month.startDate,
                    $lte: month.endDate,
                },
                campus: {
                    id: id,
                },
            },
        })
            .then((it) => it.reduce((acc, curr) => curr.total + acc, 0));
        let previousGiving = await strapi.entityService
            .findMany("api::mavuno-giving.mavuno-giving", {
            filters: {
                date: {
                    $gte: previousMonth.startDate,
                    $lte: previousMonth.endDate,
                },
                campus: {
                    id: id,
                },
            },
        })
            .then((it) => it.reduce((acc, curr) => curr.total + acc, 0));
        let currentExpense = await strapi.entityService
            .findMany("api::expense.expense", {
            filters: {
                date: {
                    $gte: month.startDate,
                    $lte: month.endDate,
                },
                campus: {
                    id: id,
                },
            },
        })
            .then((it) => it.reduce((acc, curr) => curr.amount + acc, 0));
        let previousExpense = await strapi.entityService
            .findMany("api::expense.expense", {
            filters: {
                date: {
                    $gte: previousMonth.startDate,
                    $lte: previousMonth.endDate,
                },
                campus: {
                    id: id,
                },
            },
        })
            .then((it) => it.reduce((acc, curr) => curr.amount + acc, 0));
        let currentRegisteredMembers = await strapi.entityService.count("api::member.member", {
            filters: {
                createdAt: {
                    $gte: month.startDate,
                    $lte: month.endDate,
                },
                campus: {
                    id: id,
                },
            },
        });
        let previousRegisteredMembers = await strapi.entityService.count("api::member.member", {
            filters: {
                createdAt: {
                    $gte: previousMonth.startDate,
                    $lte: previousMonth.endDate,
                },
                campus: {
                    id: id,
                },
            },
        });
        let allocationThisMonth = await strapi.entityService
            .findMany("api::money-allocation.money-allocation", {
            filters: {
                date: {
                    $gte: month.startDate,
                    $lte: month.endDate,
                },
                campus: {
                    id: id,
                },
            },
        })
            .then((it) => it.reduce((acc, curr) => curr.amount + acc, 0));
        let allocationLastMonth = await strapi.entityService
            .findMany("api::money-allocation.money-allocation", {
            filters: {
                date: {
                    $gte: previousMonth.startDate,
                    $lte: previousMonth.endDate,
                },
                campus: {
                    id: id,
                },
            },
        })
            .then((it) => it.reduce((acc, curr) => curr.amount + acc, 0));
        let balanceThisMonth = allocationThisMonth - currentExpense;
        let balanceLastMonth = allocationLastMonth - previousExpense;
        let remainingPercentage = (balanceThisMonth / allocationThisMonth) * 100;
        let cardData = {
            month: month.name,
            date: month.startDate,
            members: {
                thisMonth: currentRegisteredMembers,
                lastMonth: previousRegisteredMembers,
                trend: (0, network_1.getTrend)(currentRegisteredMembers, previousRegisteredMembers),
            },
            giving: {
                thisMonth: currentGiving,
                lastMonth: previousGiving,
                trend: (0, network_1.getTrend)(currentGiving, previousGiving),
            },
            expense: {
                thisMonth: currentExpense,
                lastMonth: previousExpense,
                trend: (0, network_1.getTrend)(currentExpense, previousExpense),
                remainingPercentage: remainingPercentage,
            },
            allocation: {
                thisMonth: allocationThisMonth,
                lastMonth: allocationLastMonth,
                trend: (0, network_1.getTrend)(allocationThisMonth, allocationLastMonth),
            },
            balance: {
                remainingAmount: balanceThisMonth,
                thisMonthBalance: balanceThisMonth,
                lastMonthBalance: balanceLastMonth,
                remainingPercentage: remainingPercentage,
                balanceTrend: (0, network_1.getTrend)(balanceThisMonth, balanceLastMonth),
            },
        };
        if (type === "graph") {
            let chartData = [];
            for (let yidx = 0; yidx < theYear.length; yidx++) {
                const month = theYear[yidx];
                let results = await strapi.entityService
                    .findMany("api::expense.expense", {
                    filters: {
                        date: {
                            $gte: month.startDate,
                            $lte: month.endDate,
                        },
                        campus: {
                            id: {
                                $eq: campus.id,
                            },
                        },
                    },
                    populate: "*",
                })
                    .then((it) => {
                    return it.reduce((acc, curr) => curr.amount + acc, 0);
                });
                chartData.push({
                    month: month.name,
                    total: results,
                });
            }
            ctx.body = {
                data: chartData.reverse(),
                meta: {},
            };
            return;
        }
        let recent = await strapi.entityService.findMany("api::expense.expense", {
            filters: {
                campus: { id: campusId },
            },
            sort: "date:desc",
            populate: "*",
            limit: 8,
        });
        for (let index = 0; index < recent.length; index++) {
            const expense = recent[index];
            recent[index].campus = await strapi.entityService.findOne("api::campus.campus", expense.campus.id, {
                populate: "network",
            });
        }
        recent = (0, campus_1.omitFieldsRecursively)(recent);
        let yearInfo = (0, helpers_1.getYearMonthsFromToday)();
        let recordsForTheYear = [];
        for (let yidx = 0; yidx < yearInfo.length; yidx++) {
            const info = yearInfo[yidx];
            let expenses = await strapi.entityService.findMany("api::expense.expense", {
                filters: {
                    campus: {
                        id: campusId,
                    },
                    date: {
                        $gte: info.startDate,
                        $lte: info.endDate,
                    },
                },
            });
            let total = expenses.reduce((acc, expense) => acc + expense.amount, 0);
            recordsForTheYear.push({
                month: info.name,
                total,
            });
        }
        ctx.body = {
            data: {
                ...cardData,
                recent,
                year: recordsForTheYear,
            },
        };
    },
}));
async function findNetworkExpenses(network, strapi, period) {
    let campusIds = await strapi.entityService
        .findMany("api::campus.campus", {
        filters: {
            network: {
                id: network.id,
            },
        },
    })
        .then((it) => it.map((campus) => campus.id));
    let expenses = await strapi.entityService.findMany("api::expense.expense", {
        filters: {
            date: {
                $gte: period,
            },
            campus: {
                id: {
                    $in: campusIds,
                },
            },
        },
        populate: "*",
    });
    // let grouped = groupByNest(expenses, "campus.name");
    let bymap = expenses.reduce((prev, expense) => {
        if (expense.campus.name in prev) {
            prev[expense.campus.name].push(expense);
        }
        else {
            prev[expense.campus.name] = [];
            prev[expense.campus.name].push(expense);
        }
        return prev;
    }, {});
    // bymap = {campus:[expense]}
    let networkSummary = Object.keys(bymap).map((key) => {
        let expense = bymap[key].reduce((sum, ex) => ex.amount + sum, 0);
        return { campus: key, expense };
    });
    let reduced = networkSummary.reduce((sum, it) => sum + it.expense, 0);
    return {
        expense: reduced,
        entries: networkSummary,
    };
}
