"use strict";
/**
 * cohort controller
 */
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController("api::cohort.cohort", () => ({
    async attendances(ctx) {
        const { data } = ctx.request.body;
        switch (data.group) {
            case "Ndoa": {
                const attendance = await strapi.entityService.create("api::ndoa.ndoa", {
                    data: {
                        ...data,
                        publishedAt: new Date(),
                    },
                });
                ctx.response.status = 201;
                ctx.response.body = attendance;
                break;
            }
            case "Mizizi": {
                const attendance = await strapi.entityService.create("api::mizizi.mizizi", {
                    data: {
                        ...data,
                        publishedAt: new Date(),
                    },
                });
                ctx.response.status = 201;
                ctx.response.body = attendance;
                break;
            }
            case "Lea": {
                const attendance = await strapi.entityService.create("api::lea.lea", {
                    data: {
                        ...data,
                        publishedAt: new Date(),
                    },
                });
                ctx.response.status = 201;
                ctx.response.body = attendance;
                break;
            }
        }
    },
}));
