"use strict";
/**
 * campus-trend controller
 */
Object.defineProperty(exports, "__esModule", { value: true });
const strapi_1 = require("@strapi/strapi");
exports.default = strapi_1.factories.createCoreController('api::campus-trend.campus-trend', ({ strapi }) => ({
    async attendances(ctx) {
        const payload = ctx.request.body;
        const zetech = await strapi.entityService.create("api::zetech-campus.zetech-campus", {
            data: {
                date: payload.date,
                female: payload.zetechGirls,
                male: payload.zetechBoys,
                total: payload.zetechTotal,
                publishedAt: new Date()
            }
        });
        const campusTrend = await strapi.entityService.create("api::campus-trend.campus-trend", {
            data: {
                date: payload.date,
                female: payload.campusGirls,
                male: payload.campusBoys,
                total: payload.campusTotal,
                publishedAt: new Date()
            }
        });
        const stateHouse = await strapi.entityService.create("api::statehouse-school.statehouse-school", {
            data: {
                attendance: payload.stateGirls,
                date: payload.date,
                publishedAt: new Date()
            }
        });
        ctx.response.body = {
            zetech,
            campusTrend,
            stateHouse
        };
        return {
            zetech,
            campusTrend,
            stateHouse
        };
    }
}));
