"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    // exampleAction: async (ctx, next) => {
    //   try {
    //     ctx.body = 'ok';
    //   } catch (err) {
    //     ctx.body = err;
    //   }
    // }
    //
    async org(ctx) {
        try {
            const user = await getLoggedInUser(ctx);
            console.log(user);
            if ((user === null || user === void 0 ? void 0 : user.accessType) === "Organisation") {
                ctx.send(user);
                return;
            }
            else {
                ctx.send({ message: "Not authorised" }, 401);
                return;
            }
        }
        catch (err) {
            console.error(err);
            ctx.send({ message: err.message }, 500);
        }
    },
    networks: async (ctx) => {
        try {
            const user = await getLoggedInUser(ctx);
            if ((user === null || user === void 0 ? void 0 : user.accessType) === "Network") {
                ctx.send(user);
                return;
            }
            else {
                ctx.send({ message: "Not authorised" }, 401);
                return;
            }
        }
        catch (err) {
            console.error(err);
            ctx.send({ message: err.message }, 500);
        }
    },
    campuses: async (ctx) => {
        try {
            const user = await getLoggedInUser(ctx);
            if ((user === null || user === void 0 ? void 0 : user.accessType) === "Campus") {
                ctx.send(user);
                return;
            }
            else {
                ctx.send({ message: "Not authorised" }, 401);
                return;
            }
        }
        catch (err) {
            console.error(err);
            ctx.send({ message: err.message }, 500);
        }
    },
    forms: async (ctx) => {
        try {
            const user = await getLoggedInUser(ctx);
            if ((user === null || user === void 0 ? void 0 : user.accessType) === "Forms") {
                ctx.send(user);
                return;
            }
            else {
                ctx.send({ message: "Not authorised" }, 401);
                return;
            }
        }
        catch (err) {
            console.error(err);
            ctx.send({ message: err.message }, 500);
        }
    },
};
async function getLoggedInUser(ctx) {
    const { identifier, password } = ctx.request.body;
    await strapi
        .plugin("users-permissions")
        .controllers.auth.callback(ctx, "local");
    const user = ctx.body.user;
    const fullUser = await strapi.entityService.findOne("plugin::users-permissions.user", user.id, {
        populate: "*",
    });
    delete fullUser.password;
    delete fullUser.resetPasswordToken;
    delete fullUser.confirmationToken;
    delete fullUser.provider;
    delete fullUser.createdBy;
    delete fullUser.updatedBy;
    delete fullUser.createdBy;
    delete fullUser.confirmed;
    delete fullUser.blocked;
    delete fullUser.updatedAt;
    delete fullUser.createdAt;
    const loggedInUser = {
        ...fullUser,
        jwt: ctx.body.jwt,
    };
    return loggedInUser;
}
