"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = [
    "strapi::errors",
    {
        name: "strapi::security",
        config: {
            contentSecurityPolicy: {
                useDefaults: true,
                directives: {
                    "connect-src": ["'self'", "https:"],
                    "img-src": [
                        "'self'",
                        "data:",
                        "blob:",
                        "storage.googleapis.com",
                        "dl.airtable.com",
                    ],
                    "media-src": [
                        "'self'",
                        "data:",
                        "blob:",
                        "storage.googleapis.com",
                        "dl.airtable.com",
                    ],
                    upgradeInsecureRequests: null,
                },
            },
        },
    },
    "strapi::security",
    "strapi::cors",
    "strapi::poweredBy",
    "strapi::logger",
    "strapi::query",
    "strapi::body",
    "strapi::session",
    "strapi::favicon",
    "strapi::public",
];
