"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = ({ env }) => ({
    email: {
        config: {
            provider: "strapi-provider-email-resend",
            providerOptions: {
                apiKey: env("RESEND_API_KEY"), // Required
            },
            settings: {
                defaultFrom: "me@example.com",
                defaultReplyTo: "me@example.com",
            },
        },
    },
    upload: {
        config: {
            provider: "strapi-provider-firebase-storage",
            providerOptions: {
                serviceAccount: require("../../../mavunostorage-firebase-adminsdk-rkmag-e6443e8798.json"),
                // Custom bucket name
                bucket: env("STORAGE_BUCKET_URL", "my-bucket-name.appspot.com"),
                sortInStorage: true,
                debug: false, // true | false
            },
        },
    },
});
